% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fn_exp_numeric.R
\name{ExpNumStat}
\alias{ExpNumStat}
\title{Summary statistics for numerical variables}
\usage{
ExpNumStat(data,by=c("A","G","GA"),gp=NULL,Qnt=NULL,MesofShape=2,Outlier=FALSE,round=3)
}
\arguments{
\item{data}{dataframe or matrix}

\item{by}{group by A (summary statistics by All), G (summary statistics by group), GA (summary statistics by group and Overall)}

\item{gp}{target variable if any, default NULL}

\item{Qnt}{default NULL. Specified quantiles [c(.25,0.75) will find 25th and 75th percentiles]}

\item{MesofShape}{Measures of shapes (Skewness and kurtosis).}

\item{Outlier}{Calculate the lower hinge, upper hinge and number of outliers}

\item{round}{round off}
}
\value{
summary statistics for numeric independent variables

Summary by – overall

Summary by – group (target variable)

Summary by – overall and group (target variable)

coloumn descriptions

•	Vname – Variable name

•	Group – Target variable

•	TN – Total sample

•	nNeg – Total negative observations

•	nZero – Total zero observations

•	nPos – Total positive observations

•	NegInf – Negative infinite count

•	PosInf – Positive infinite count

•	NA_value – Not Applicable count

•	Per_of_Missing – Percentage of missings

•	Min – minimum value

•	Max – maximum value

•	Mean – average value

•	Median – median value

•	SD – Standard deviation

•	CV – coefficient of variations (SD/mean)*100

•	IQR – Inter quartile range

•	Qnt – Specified quantiles

•	MesofShape – Skewness and Kurtosis

•	Outlier – Number of outliers

•	Cor – Correlation b/w target and independent variables
}
\description{
Function provides summary statistics for all numerical variable. This function automatically scans through each variable and select only numeric/integer variables. Also if we know the target variable, function will generate relationship between target variable and each independent variable.
}
\examples{
## Descriptive summary of numeric variables - Summary by Target variables
ExpNumStat(mtcars,by="G",gp="gear",Qnt=c(0.1,0.2),MesofShape=2,Outlier=TRUE,round=3)
## Descriptive summary of numeric variables - Summary by Overall
ExpNumStat(mtcars,by="A",gp="gear",Qnt=c(0.1,0.2),MesofShape=2,Outlier=TRUE,round=3)
## Descriptive summary of numeric variables - Summary by Overall and Group
ExpNumStat(mtcars,by="GA",gp="gear",Qnt=seq(0,1,.1),MesofShape=1,Outlier=TRUE,round=2)
}
\seealso{
\code{\link[psych:describe.by]{describe.by}}
}
\author{
dubrangala
}
