% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SmCCNet-source.R
\name{getAbar}
\alias{getAbar}
\title{Calculate similarity matrix based on canonical weights.}
\usage{
getAbar(Ws, FeatureLabel = NULL)
}
\arguments{
\item{Ws}{A canonical correlation weight vector or matrix. If \code{Ws} is a
matrix, then each column corresponds to one weight vector.}

\item{FeatureLabel}{A vector of feature labels for each feature in the adjacency matrix}
}
\value{
A \eqn{p\times p} symmetric non-negative matrix.
}
\description{
Compute the similarity matrix based on the outer products of absolute
canonical correlation weights, can be used for both single and multi-omics setting.
}
\examples{

w <- matrix(rnorm(6), nrow = 3)
Ws <- apply(w, 2, function(x)return(x/sqrt(sum(x^2))))
abar <- getAbar(Ws,  FeatureLabel = c('omics1', 'omics2', 'omics3'))

}
