% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SmCCNetSource.R
\name{getRobustPseudoWeights}
\alias{getRobustPseudoWeights}
\title{Calculate the canonical correlation weights based on sparse multiple
canonical correlation analysis (SmCCA), sparse supervised canonical 
correlation analysis (SsCCA), or sparse canonical correlation analysis (SCCA).}
\usage{
getRobustPseudoWeights(X1, X2, Trait, Lambda1, Lambda2, s1 = 0.7, s2 = 0.7,
  NoTrait = FALSE, FilterByTrait = FALSE, SubsamplingNum = 1000,
  CCcoef = NULL, trace = FALSE)
}
\arguments{
\item{X1}{An \eqn{n\times p_1} data matrix (e.g. mRNA) with \eqn{p_1} 
features and \eqn{n} subjects.}

\item{X2}{An \eqn{n\times p_2} data matrix (e.g. miRNA) with \eqn{p_2} 
features and \eqn{n} subjects.}

\item{Trait}{An \eqn{n\times 1} trait data matrix for the same n subjects.}

\item{Lambda1}{LASSO penalty parameter for \code{X1}. \code{Lambda1} needs
to be between 0 and 1.}

\item{Lambda2}{LASSO penalty parameter for \code{X2}. \code{Lambda2} needs 
to be between 0 and 1.}

\item{s1}{Proportion of mRNA features to be included, default at \code{s1 = 0.7}.
\code{s1} needs to be between 0 and 1.}

\item{s2}{Proportion of miRNA features to be included, default at \code{s1 = 0.7}.
\code{s2} needs to be between 0 and 1.}

\item{NoTrait}{Logical, default is \code{FALSE}. Whether trait information is
provided.}

\item{FilterByTrait}{Logical, default is \code{FALSE}. Whether only the top 
(\eqn{80\%}) features with highest correlation to the trait will be assigned 
nonzero weights. The choice of \eqn{80\%} is based on the PMA package.}

\item{SubsamplingNum}{Number of feature subsamples. Default is 1000. Larger
number leads to more accurate results, but at a higher cost.}

\item{CCcoef}{Optional coefficients for the SmCCA pairwise canonical 
correlations. If \code{CCcoef = NULL} (default), then the objective 
function is the total sum of all pairwise canonical correlations. It can 
also be a coefficient vector that follows the column order of 
\code{combn(K, 2)}.}

\item{trace}{Logical. Whether to display the CCA algorithm trace.}
}
\value{
A canonical correlation weight matrix with \eqn{p_1+p_2} rows. Each 
  column is the canonical correlation weights based on subsampled \code{X1}
  and \code{X2} features. The number of columns is \code{SubsamplingNum}.
}
\description{
Integrate two omics data type (and a quantitative phenotype), and calculate
the absolute canonical correlation weights for the omics features using SmCCA
SsCCA, or SCCA. SmCCA and SsCCA take into account a phenotype/trait. SmCCA 
maximizes the total (weighted or unweighted) pairwise canonical correlation 
weights between two omics data types and the trait. It requires the trait to 
be quantitative. SsCCA prioritizes omics features based on the trait, and 
assigns non-zero canonical weights to features that are more correlated to 
the trait. SCCA does not use any trait information for computing the 
canonical correlation weights. All of these three methods are included in 
this function, along with an omics feature subsampling scheme.
}
\details{
To choose SmCCA, set \code{NoTrait = FALSE, FilterByTrait = FALSE}.  
To choose SsCCA, set \code{NoTrait = FALSE, FilterByTrait = TRUE}.
To choose SCCA, set \code{Trait = NULL, NoTrait = TRUE}.
}
\examples{

## For illustration, we only subsample 5 times.
set.seed(123)

# Unweighted SmCCA
W1 <- getRobustPseudoWeights(geneExpr, mirnaExpr, Trait = pheno, Lambda1 = 0.05,
  Lambda2 = 0.05, s1 = 0.7, s2 = 0.9, NoTrait = FALSE, FilterByTrait = FALSE,
  SubsamplingNum = 5, CCcoef = NULL, trace = FALSE)
  
# Weighted SmCCA
W2 <- getRobustPseudoWeights(geneExpr, mirnaExpr, Trait = pheno, Lambda1 = 0.05,
  Lambda2 = 0.05, s1 = 0.7, s2 = 0.9, NoTrait = FALSE, FilterByTrait = FALSE,
  SubsamplingNum = 5, CCcoef = c(1, 5, 5), trace = FALSE)
  
# SsCCA
W3 <- getRobustPseudoWeights(geneExpr, mirnaExpr, Trait = pheno, Lambda1 = .05, Lambda2 = 0.5,
  s1 = 0.7, s2 = 0.9, NoTrait = FALSE, FilterByTrait = TRUE,
  SubsamplingNum = 5, CCcoef = NULL, trace = FALSE)

# SCCA
W4 <- getRobustPseudoWeights(geneExpr, mirnaExpr, Trait = NULL, Lambda1 = 0.05,
  Lambda2 = 0.05, s1 = 0.7, s2 = 0.9, NoTrait = TRUE, 
  SubsamplingNum = 5, CCcoef = NULL, trace = FALSE)
  

}
