% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Probability_calculate.R
\name{calculate_probability}
\alias{calculate_probability}
\title{Calculate gene set expression and infer probabilities with control datasets (Use in package)}
\usage{
calculate_probability(
  object,
  features,
  assay = NULL,
  cluster_col = NULL,
  min_expression = 0.1,
  specificity_weight = 3
)
}
\arguments{
\item{object}{Enter a Seurat object.}

\item{features}{Enter one or a set of markers.}

\item{assay}{Enter the assay used by the Seurat object, such as "RNA". Default
parameters use "assay = NULL".}

\item{cluster_col}{Enter the meta.data column in the Seurat object to be
annotated, such as "seurat_cluster". Default parameters use "cluster_col = NULL".}

\item{min_expression}{The min_expression parameter defines a threshold value to
determine whether a cell's expression of a feature is considered "expressed"
or not. It is used to filter out low-expression cells that may contribute
noise to the analysis. Default parameters use "min_expression = 0.1".}

\item{specificity_weight}{The specificity_weight parameter controls how much the
expression variability (standard deviation) of a feature within a cluster
contributes to its "specificity score." It amplifies or suppresses the impact
of variability in the final score calculation.Default parameters use
"specificity_weight = 3".}
}
\value{
Average expression of genes in the input "Seurat" object given
"cluster_col" and given "features".
}
\description{
Calculate gene set expression and infer probabilities with control datasets (Use in package)
}
