\name{skewhypFit}
\alias{skewhypFit}
\alias{plot.skewhypFit}
\alias{print.skewhypFit}
\title{
  Fit the Skew Hyperbolic Student t-Distribution to Data
}
\description{
  Fits a skew hyperbolic \emph{t}-distribution to given data.
  Displays the histogram, log-histogram (both with fitted densities),
  Q-Q plot and P-P plot for the fit which has maximum likelihood.
}
\usage{
skewhypFit(x, freq = NULL, breaks = NULL, startValues = "LA",
           paramStart = NULL, method = "Nelder-Mead", hessian = TRUE,
           plots = TRUE, printOut = TRUE, controlBFGS = list(maxit = 200),
           controlNM = list(maxit = 1000), maxitNLM = 1500, ...)
\method{plot}{skewhypFit}(x, which = 1:4,
     plotTitles = paste(c("Histogram of ", "Log-Histogram of ",
     "Q-Q Plot of ", "P-P Plot of "), x$obsName, sep = ""),
     ask = prod(par("mfcol")) < length(which) && dev.interactive(), ...)
\method{print}{skewhypFit}(x,digits = max(3, getOption("digits") - 3),...)
}
\arguments{
  \item{x}{Data vector for \code{skewhypFit}. Object of class
    \code{"skewhypFit"} for \code{print.skewhypFit}.}
  \item{freq}{Vector of weights with length equal to length of \code{x}.}
  \item{breaks}{Breaks for histogram, defaults to those generated by
    \code{hist(x, plot = FALSE, right = FALSE).}If \code{startValues = "LA"}
    then 30 breaks are used by default.} 
  \item{startValues}{Code giving the method of determining starting
    values for finding the maximum likelihood estimates of the
    parameters.}  \item{paramStart}{If \code{startValues = "US"} the
    user must specify a vector of starting parameter values in the form
    \code{c(mu,delta,beta,nu)}.} 
  \item{method}{Different optimisation methods to consider, see
    \bold{Details}.}
  \item{hessian}{Logical; if \code{hessian = TRUE} the value of the
    hessian is returned.}
  \item{plots}{Logical; if \code{plots = TRUE} the histogram,
    log-histogram, Q-Q and P-P plots are printed.}
  \item{printOut}{Logical; if \code{printOut = TRUE} results of the
    fitting are printed.}
  \item{controlBFGS}{A list of control parameters for \code{optim} when
    using the \code{"BFGS"} optimisation.}
  \item{controlNM}{A list of control parameters for \code{optim}
    when using the \code{"Nelder-Mead"} optimisation.}
  \item{maxitNLM}{A positive integer specifying the maximum number of
    iterations when using the \code{"nlm"} optimisation.}
  \item{which}{If a subset of plots is required, specify a subset of the
    numbers \code{1:4}.}
  \item{plotTitles}{Titles to appear above the plots.}
  \item{ask}{Logical; if \code{TRUE} the user is asked before plot
    change, see \code{\link{par}(ask = .)}.}
  \item{digits}{Desired number of digits when the object is printed.}
  \item{\dots}{Passes arguments to \code{\link{optim}}, \code{\link{nlm}},
    \code{\link{hist}},\code{\link[DistributionUtils]{logHist}},
    \code{\link{qqskewhyp}} and \code{\link{ppskewhyp}}.}
}
\details{
  \code{startValues} can be either \code{"US"}(User-supplied) or
  \code{"LA"} (Linear approximation)
  If \code{startValues = "US"} then a value for \code{paramStart} must be
  supplied. For the details concerning the use of \code{startValues}
  and \code{paramStart} see \code{\link{skewhypFitStart}}.

  The three optimisation methods currently available are:
  \itemize{
    \item{\code{"BFGS"}}{Uses the quasi-Newton method \code{"BFGS"} as
    documented in \code{\link{optim}}.}
    \item{\code{"Nelder-Mead"}}{Uses an implementation of the Nelder and
    Mead method as documented in \code{\link{optim}}.}
    \item{\code{"nlm"}}{Uses the \code{\link{nlm}} function in R.}
  }
  For the details of how to pass control information using
  \code{\link{optim}} and \code{\link{nlm}}, see \code{\link{optim}} and
  \code{\link{nlm}.}
}
\value{
  \code{skewhypFit} returns a list with components:
  \item{param}{A vector giving the maximum likelihood estimates of the
    parameters in the form \code{c(mu,delta,beta,nu)}.}
  \item{maxLik}{The value of the maximised log-likelihood.}
  \item{hessian}{If \code{hessian} was set to \code{TRUE}, the value of
    the hessian, not present otherwise.}
  \item{method}{Optimisation method used.}
  \item{conv}{Convergence code. See \code{\link{optim}} or
    \code{\link{nlm}} for details.}
  \item{iter}{Number of iterations of optimisation routine.}
  \item{x}{The data used to fit the distribution.}
  \item{xName}{Character string with the actual \code{x} argument name.}
  \item{paramStart}{Starting values of the parameters returned by
    \code{\link{skewhypFitStart}}.}
  \item{svName}{Name of the method used to find starting values.}
  \item{startValues}{Acronym of method used to find starting values.}
  \item{breaks}{Cell boundaries found by a call to \code{\link{hist}}.}
  \item{midpoints}{The cell midpoints found by a call to
    \code{\link{hist}}.}
  \item{empDens}{The estimated density found by a call to
    \code{\link{hist}} if \code{startValues = "US"}, or
    \code{\link{density}} if \code{startValues = "LA"}.}
}
\references{
  Aas, K. and Haff, I. H. (2006).
  The Generalised Hyperbolic Skew Student's \emph{t}-distribution,
  \emph{Journal of Financial Econometrics}, \bold{4}, 275--309.
}
\author{
  David Scott \email{d.scott@auckland.ac.nz}, Fiona Grimson
}
\seealso{
  \code{\link{optim}}, \code{\link{nlm}}, \code{\link{par}},
  \code{\link{hist}}, \code{\link{density},}
  \code{\link[DistributionUtils]{logHist}},
  \code{\link{qqskewhyp}}, \code{\link{ppskewhyp}},
  \code{\link{dskewhyp}} and \code{\link{skewhypFitStart}}.
}
\examples{
## See how well skewhypFit works
param <- c(0, 1, 4, 10)
data <- rskewhyp(500, param = param)
fit <- skewhypFit(data)
## Use data set NOK/EUR as per Aas&Haff
data(lrnokeur)
nkfit <- skewhypFit(lrnokeur, method = "nlm")
## Use data set DJI
data(lrdji)
djfit <- skewhypFit(lrdji)
}

\keyword{distribution}
