% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ss.data.thickness2}
\alias{ss.data.thickness2}
\title{Metal Plates thickness (extended)}
\format{A data frame with 84 observations on the following 5 variables.
\describe{ \item{day}{a factor with the day (seven days)}
\item{shift}{a factor with the shift (two shifts)}
\item{thickness}{a numeric vector with the thickness (\emph{in})}
\item{ushift}{a factor with the day-shift combination}
\item{flaws}{an integer vector with the number of flaws on the
surface of sampled plates} }}
\source{
Examples 8.1 and 9.9 in the reference below.
}
\usage{
data("ss.data.thickness2")
}
\description{
This data set contains the thickness and additional data for 84 metal
plates.
}
\details{
This data set illustrates concepts in the book ``Quality Control with R''.
}
\examples{

data(ss.data.thickness2)
str(ss.data.thickness2) 
lattice::dotplot(thickness ~ shift | day,
    data = ss.data.thickness2,
    layout = c(7, 1))

}
\references{
Cano, E.L. and Moguerza, J.M. and Prieto Corcoba, M. (2015)
\emph{Quality Control with R. An ISO Standards Approach}. Springer.
}
\keyword{datasets}
