% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric-measures.R
\name{LOR}
\alias{LOR}
\title{Log-odds ratio}
\usage{
LOR(
  A_data,
  B_data,
  condition,
  outcome,
  baseline_phase = NULL,
  intervention_phase = NULL,
  improvement = "increase",
  scale = "percentage",
  intervals = NULL,
  D_const = NULL,
  bias_correct = TRUE,
  confidence = 0.95
)
}
\arguments{
\item{A_data}{vector of numeric data for A phase. Missing values are dropped.}

\item{B_data}{vector of numeric data for B phase. Missing values are dropped.}

\item{condition}{vector identifying the treatment condition for each
observation in the series.}

\item{outcome}{vector of outcome data for the entire series.}

\item{baseline_phase}{character string specifying which value of
\code{condition} corresponds to the baseline phase. Defaults to first
observed value of \code{condition}.}

\item{intervention_phase}{character string specifying which value of
\code{condition} corresponds to the intervention phase. Defaults to second
unique value of \code{condition}.}

\item{improvement}{character string indicating direction of improvement.
Default is "increase".}

\item{scale}{character string indicating the scale of the outcome variable.
Must be either \code{"percentage"} for percentages with range 0-100 or
\code{"proportion"} for proportions with range 0-1. If a vector, the most
frequent unique value will be used. \code{"percentage"} is assumed by
default.}

\item{intervals}{for interval recording procedures, the total number of
intervals per observation session. If a vector, the mean number of
intervals will be used.}

\item{D_const}{constant used for calculating the truncated sample mean (see
Pustejovsky, 2015). If a vector, the mean value will be used.}

\item{bias_correct}{logical value indicating whether to use bias-correction.
Default is \code{TRUE}.}

\item{confidence}{confidence level for the reported interval estimate. Set to
\code{NULL} to omit confidence interval calculations.}
}
\value{
A data.frame containing the estimate, standard error, and approximate
  confidence interval.
}
\description{
Calculates the log-odds ratio effect size index, with or without
  bias correction (Pustejovsky, 2015)
}
\details{
The odds ratio parameter is the ratio of the odds of the outcome.
  The log-odds ratio is the natural logarithm of the odds ratio. This effect
  size is appropriate for outcomes measured on a percentage or proportion
  scale. Unlike the LRRd and LRRi, the LOR is symmetric in valence, so that
  the LOR for an positively-valenced outcome is equal to -1 times the LOR
  calculated after reversing the scale of the outcome so that it is
  negatively valenced.

  Without bias correction, the log-odds ratio is estimated by substituting
  the sample mean level in each phase in place of the corresponding
  parameter. A delta-method bias correction to the estimator is used by
  default.

  The standard error of LOR is calculated based on a delta-method
  approximation, allowing for the possibility of different degrees of
  dispersion in each phase. The confidence interval for LOR is based on a
  large-sample (z) approximation.

  To account for the possibility of sample means of zero, a truncated mean is
  calculated following the method described in Pustejovsky (2015). Truncated
  sample variances are also calculated to ensure that standard errors will be
  strictly larger than zero. The truncation constant depends on the total
  number of intervals per session (or the total number of items for other
  percentage/proportion scales). The arguments \code{scale} and
  \code{intervals} must be specified in order to calculate an appropriate
  truncation constant. For outcomes measured using continuous recording
  procedures, set \code{intervals} equal to 60 times the length of the
  observation session in minutes.
}
\examples{
A_pct <- c(20, 20, 25, 25, 20, 25)
B_pct <- c(30, 25, 25, 25, 35, 30, 25)
LOR(A_data = A_pct, B_data = B_pct,
    scale = "percentage", intervals = 20, bias_correct = FALSE)
LOR(A_data = A_pct, B_data = B_pct,
    scale = "percentage", intervals = 20)

LOR(A_data = A_pct, B_data = B_pct, scale = "percentage")
LOR(A_data = A_pct / 100, B_data = B_pct / 100, scale = "proportion")
LOR(A_data = A_pct, B_data = B_pct, scale = "percentage", improvement = "decrease")

}
\references{
Pustejovsky, J. E. (2015). Measurement-comparable effect sizes
  for single-case studies of free-operant behavior. \emph{Psychological
  Methods, 20}(3), 342--359.
  doi:\doi{10.1037/met0000019}
}
