% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmvdeming.h.R
\name{jmvdeming}
\alias{jmvdeming}
\title{Deming Regression}
\usage{
jmvdeming(
  data,
  method1,
  method2,
  ciWidth = 95,
  testValue = 1,
  plotcon = FALSE,
  plotcheck = FALSE,
  weighted = FALSE,
  xlabel = "Method: 1",
  ylabel = "Method: 2"
)
}
\arguments{
\item{data}{Data}

\item{method1}{Name of column containing 1st Vector of data}

\item{method2}{Name of column containing Vector of data}

\item{ciWidth}{a number between 50 and 99.9 (default: 95), the width of
confidence intervals}

\item{testValue}{Ratio of the two error variances. Default is 1.}

\item{plotcon}{\code{TRUE} or \code{FALSE} (default), for Bland-Altman plot}

\item{plotcheck}{\code{TRUE} or \code{FALSE} (default), assumptions plots}

\item{weighted}{\code{TRUE} or \code{FALSE}}

\item{xlabel}{The label for the x-axis}

\item{ylabel}{The label for the y-axis}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$text} \tab \tab \tab \tab \tab a preformatted \cr
  \code{results$demtab} \tab \tab \tab \tab \tab a table \cr
  \code{results$plotcon} \tab \tab \tab \tab \tab an image \cr
  \code{results$plotcheck} \tab \tab \tab \tab \tab an image \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$demtab$asDF}

\code{as.data.frame(results$demtab)}
}
\description{
Deming Regression
}
