% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{test_2x2_dom}
\alias{test_2x2_dom}
\title{Simulate a 2x2 Crossover Design and Compute Difference of Means (DOM)}
\usage{
test_2x2_dom(
  n,
  muT,
  muR,
  SigmaW,
  lequi_tol,
  uequi_tol,
  alpha,
  sigmaB,
  dropout,
  Eper,
  Eco,
  typey,
  adseq,
  k,
  arm_seed
)
}
\arguments{
\item{n}{integer number of subjects per sequence}

\item{muT}{vector mean of endpoints on treatment arm}

\item{muR}{vector mean of endpoints on reference arm}

\item{SigmaW}{matrix  within subject covar-variance matrix across endpoints}

\item{lequi_tol}{vector  lower equivalence tolerance band across endpoints}

\item{uequi_tol}{vector  upper equivalence tolerance band across endpoints}

\item{alpha}{vector alpha value across endpoints}

\item{sigmaB}{double between subject variance (assumed same for all endpoints)}

\item{dropout}{vector of size 2 with dropout proportion per sequence (0,1)}

\item{Eper}{vector of size 2 with period effect on period (0,1)}

\item{Eco}{vector of size 2 with carry over effect of arm c(Reference, Treatment).}

\item{typey}{vector with positions of primary endpoints}

\item{adseq}{boolean is used a sequential adjustment?}

\item{k}{integer minimum number of equivalent endpoints}

\item{arm_seed}{seed for the simulation}
}
\value{
A numeric matrix containing the simulated hypothesis test results.
The first column represents the overall equivalence decision, where 1 indicates
success and 0 indicates failure. The subsequent columns contain the hypothesis
test results for each endpoint, followed by mean estimates for the reference and
treatment groups, and standard deviations for the reference and treatment groups.
}
\description{
Simulates a two-sequence, two-period (2x2) crossover design and evaluate equivalence for the difference of means (DOM).
}
