% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{phi_plot}
\alias{phi_plot}
\title{Create `ontology_plot' of phi}
\usage{
phi_plot(ontology, phi, max_terms = 10, min_frequency = 0,
  colour_gradient = FALSE, size_gradient = TRUE, custom_labels = c(),
  show_proportion = TRUE, fillcolor = NULL, ...)
}
\arguments{
\item{ontology}{\code{ontology_index} object.}

\item{phi}{List of character vectors of term IDs, as sampled by \code{sim_reg} procedure.}

\item{max_terms}{Specify the maximum number of terms to appear in the plot.}

\item{min_frequency}{Threshold frequency for including terms in plot.}

\item{colour_gradient}{Logical indicating whether to colour terms in the plot according to their marginal frequencies (blue being the least frequent, yellow the most).}

\item{size_gradient}{Logical indicating whether to colour terms in the plot according to their marginal frequencies.}

\item{custom_labels}{Character vector of custom labels for terms (named by corresponding term IDs).}

\item{show_proportion}{Logical indicating whether to append the `inclusion in phi' rate to the labels in the terms.}

\item{fillcolor}{Vector of colours (named by HPO term IDs) for corresponding terms in plot.}

\item{...}{Additional parameters to be passed to \code{onto_plot}.}
}
\value{
Plots graph.
}
\description{
Create plot of marginal frequency of individual terms in context of related terms in the ontology, ready for plotting to device or exporting to dot file.
}

