% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intercorr_poly.R
\name{intercorr_poly}
\alias{intercorr_poly}
\title{Headrick's Fifth-Order Polynomial Transformation Intermediate Correlation Equations}
\usage{
intercorr_poly(r, c, a)
}
\arguments{
\item{r}{either a scalar, in which case it represents pairwise intermediate correlation between standard normal variables,
or a vector of 3 values, in which case:
\deqn{r[1]*r[2] = \rho_{z1,z2},\ r[1]*r[3] = \rho_{z1,z3},\ r[2]*r[3] = \rho_{z2,z3}}
or a vector of 4 values, in which case:
\deqn{r0 = r[5]*r[6],\ r0*r[1]*r[2] = \rho_{z1,z2},\ r0*r[1]*r[3] = \rho_{z1,z3}}
\deqn{r0*r[2]*r[3] = \rho_{z2,z3},\ r0*r[1]*r[4] = \rho_{z1,z4},\ r0*r[2]*r[4] = \rho_{z2,z4},}
\deqn{r0*r[3]*r[4] = \rho_{z3,z4}}}

\item{c}{a matrix with either 2, 3, or 4 rows, each a vector of constants c0, c1, c2, c3, like that returned by
\code{\link[SimMultiCorrData]{find_constants}}}

\item{a}{a matrix of target correlations among continuous variables; if \code{nrow(a) = 1}, it represents a pairwise
correlation; if \code{nrow(a) = 2, 3, or 4}, it represents a correlation matrix between two, three, or four variables}
}
\value{
a list of length 1 for pairwise correlations, length 3 for three variables, or length 6 for four variables;
     if the inputs satisfy the equations, returns 0 for all list elements
}
\description{
This function contains Headrick's fifth-order polynomial transformation intermediate correlation
    equations (2002, \doi{10.1016/S0167-9473(02)00072-5}).  It is used in \code{\link[SimMultiCorrData]{findintercorr}} and
    \code{\link[SimMultiCorrData]{findintercorr2}}
    to find the intermediate correlation for standard normal random variables which are used in the Headrick
    polynomial transformation.  It can be used to verify a set of constants and an intermediate correlation satisfy
    the equations for the desired post-transformation correlation.  It works for two, three, or four variables.  Headrick recommended
    using the technique of Vale & Maurelli (1983,
    \doi{10.1007/BF02293687}), in the case of more than 4 variables, in which
    the intermediate correlations are found pairwise and then eigen value decomposition is used on the correlation matrix.
    Note that there exist solutions that yield invalid power
    method pdfs (see \code{\link[SimMultiCorrData]{power_norm_corr}}, \code{\link[SimMultiCorrData]{pdf_check}}).
    This function would not ordinarily be called by the user.
}
\references{
Please see references for \code{\link[SimMultiCorrData]{findintercorr_cont}}.
}
\seealso{
\code{\link[SimMultiCorrData]{poly}}, \code{\link[SimMultiCorrData]{power_norm_corr}},
    \code{\link[SimMultiCorrData]{pdf_check}}, \code{\link[SimMultiCorrData]{find_constants}}
}
\keyword{Headrick}
\keyword{correlation,}
\keyword{intermediate,}
