% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distance_matrix}
\alias{distance_matrix}
\title{Create a distance matrix between nodes for spatial models}
\usage{
distance_matrix(x, y, cutoff, min_dist = NULL)
}
\arguments{
\item{x}{Projected x coordinate}

\item{y}{Projected y coordinate}

\item{cutoff}{The distance cutoff}

\item{min_dist}{The minimum distance to separate two nodes.  If
the coordinates for two nodes are identical, the min_dist must
be assigned or an error is raised.  Default is NULL i.e. to
raise an error.}
}
\value{
\code{dgCMatrix}
}
\description{
Calculate the euclidian distances beween coordinates for all
coordinates within the cutoff.
}
\examples{
## Generate a grid 10 x 10 and place one node in each cell
## separated by 100m.
nodes <- expand.grid(x = (0:9) * 100, y = (0:9) * 100)
plot(y ~ x, nodes)

## Define the cutoff to only include neighbors within 300m.
d <- distance_matrix(x = nodes$x, y = nodes$y, cutoff = 300)

## View the first 10 rows and columns in the distance matrix
d[1:10, 1:10]
}
