% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheduled_events.R, R/SimInf_model.R, R/SEIR.R,
%   R/SIR.R, R/SISe.R, R/SISe3.R, R/SISe3_sp.R, R/SISe_sp.R
\docType{methods}
\name{plot-methods}
\alias{plot-methods}
\alias{plot}
\alias{plot,scheduled_events-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SimInf_model-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SEIR-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SIR-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SISe-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SISe3-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SISe3_sp-method}
\alias{plot-methods}
\alias{plot}
\alias{plot,SISe_sp-method}
\title{Plot \code{\linkS4class{scheduled_events}}}
\usage{
\S4method{plot}{scheduled_events}(x, frame.plot = FALSE, ...)

\S4method{plot}{SimInf_model}(x, legend = NULL, col = NULL, lty = NULL,
  lwd = NULL, ...)

\S4method{plot}{SEIR}(x, col = c("blue", "orange", "red", "darkgreen"),
  lty = rep(1, 4), lwd = 2, ...)

\S4method{plot}{SIR}(x, col = c("blue", "red", "darkgreen"), lty = rep(1,
  3), lwd = 2, ...)

\S4method{plot}{SISe}(x, col = c("blue", "red"), lty = rep(1, 2), lwd = 2,
  ...)

\S4method{plot}{SISe3}(x, legend = expression(S[1], I[1], S[2], I[2], S[3],
  I[3]), col = rep(c("blue", "red"), 3), lty = rep(1:3, each = 2),
  lwd = 2, ...)

\S4method{plot}{SISe3_sp}(x, legend = expression(S[1], I[1], S[2], I[2], S[3],
  I[3]), col = rep(c("blue", "red"), 3), lty = rep(1:3, each = 2),
  lwd = 2, ...)

\S4method{plot}{SISe_sp}(x, col = c("blue", "red"), lty = rep(1, 2),
  lwd = 2, ...)
}
\arguments{
\item{x}{The \code{model} to plot}

\item{frame.plot}{Draw a frame around each plot. Default is FALSE.}

\item{...}{Additional arguments affecting the plot produced.}

\item{legend}{The character vector to appear in the
legend. Default is to use the names of the compartments.}

\item{col}{The plotting color for each compartment. Default is
black.}

\item{lty}{The line type for each compartment. Default is the
sequence: 1=solid, 2=dashed, 3=dotted, 4=dotdash, 5=longdash,
6=twodash.}

\item{lwd}{The line width for each compartment. Default is 2.}
}
\description{
Plot \code{\linkS4class{scheduled_events}}

Plot \code{\linkS4class{SimInf_model}}
}
\examples{
## Create a 'SISe' demo model with 1 node and initialize
## it to run over 1000 days.
model <- demo_model(nodes = 1, days = 1000, model = "SISe")

## Run the model and save the result
result <- run(model)

## Plot the proportion susceptible and infected individuals
plot(result)
}
