% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut.E.direct.R
\name{mut.E.direct}
\alias{mut.E.direct}
\title{Direct mutation of enzyme concentrations}
\usage{
mut.E.direct(E_res_fun,i_fun,nu_fun,correl_fun,beta_fun=NULL)
}
\arguments{
\item{E_res_fun}{Numeric vector of enzyme concentrations (resident)}

\item{i_fun}{Integer number indicating the enzyme targeted by the mutation}

\item{nu_fun}{Numeric value of \bold{canonical} mutation effect}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}
}
\value{
Numeric vector corresponding to mutant value of enzyme concentrations
}
\description{
Computes the mutant value of enzyme concentrations by a direct method.
}
\details{
This mutation method is named \emph{direct}, because we used canonical mutation effect to compute mutant values

This function is the one used in evolution simulation.
}
\examples{
E <- c(30,30,30)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
correl <- "RegPos"
mu <- 1 #canonical size of mutation
i <- 3 #enzyme directly targeted by mutation

mut.E.direct(E,i,mu,correl,beta)

}
\seealso{
See function \code{\link{mut.E.indirect}} for an indirect computation method of mutation.
}
