% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux.shape.from.one.point.R
\name{flux.shape.from.one.point}
\alias{flux.shape.from.one.point}
\title{Flux shape computing from one point}
\usage{
flux.shape.from.one.point(Etot_fun, A_fun, correl_fun, beta_fun=NULL, 
E_ini_fun=NULL, from.eq=TRUE, E_fun=NULL, X_fun=1, with.alpha=FALSE, grp.reg=FALSE)
}
\arguments{
\item{Etot_fun}{Numeric. The total concentration}

\item{A_fun}{Numeric vector of activities}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}

\item{E_ini_fun}{Numeric vector corresponding to initial concentrations.}

\item{from.eq}{Logical. Is the analyzed point is the equilibrium point ?
If \code{TRUE}, flux and selection coefficients are computed from the equilibrium, else \code{E_fun} is required.
Default is \code{TRUE}.}

\item{E_fun}{Numeric vector of the concentrations at analysed point.
If \code{from.eq=TRUE}, \code{E_fun} is ignored.}

\item{X_fun}{Numeric value. Default is \code{1}}

\item{with.alpha}{Logical. For case \code{CR}, is the computing method use \code{alpha} formula (TRUE) or pass by \code{tau} computing (FALSE) ?}

\item{grp.reg}{Logical. Is there is some regulation groups in beta matrix ? If \code{TRUE}, \code{tau} will not be computed and give 0.}
}
\value{
Invisible list of 6 elements:
\itemize{
   \item \code{$x} : Numeric vector of all values that mutated enzymes can take, between 0 and \code{Etot_fun}, by 0.01.
   Length of \code{(Etot_fun-0)*100}.
   \item \code{$J} : Numeric matrix of \code{n} columns and \code{(Etot_fun-0)*100} rows.
   Each column correspond to one direction (\emph{i.e. which enzyme is "mutated"}) and each row to each value of flux in this direction.
   \item \code{$sel_disc} : Numeric matrix corresponding to discrete selection coefficient.
   Same properties.
   \item \code{$sel_cont} : Numeric matrix corresponding to continuous selection coefficient.
   Same properties.
   \item \code{$tau} : Numeric matrix corresponding to position \eqn{\tau} in case of regulation.
   Same properties.
   \item \code{$param} : List of input parameters
   }
}
\description{
\code{flux.shape.from.one.point} computes flux in every dimension (corresponding to each enzyme) from a given point (vector of concentrations)
}
\details{
Every enzyme correspond to one dimension in a \emph{n}-dimensional graph.

From a given resident point \code{E_fun}, each value on dimension \emph{i} is considered as a possible mutant of enzyme concentration \eqn{E_i}.
Every "mutants" are taken between 0 and \code{Etot_fun} by 0.01 step.
In every dimension, function \code{flux.shape.from.one.point} computes flux and selection coefficient (discrete \code{\link{coef_sel.discrete}} and continuous \code{\link{coef_sel.continue}}) from this point.

\code{E_fun} (resp. \code{E_ini_fun}) is rescaled by a cross product to have sum of \code{E_fun} (resp. \code{E_ini_fun}) equal to \code{Etot_fun}.

If \code{from.eq=TRUE}, analyzed point is:
\itemize{
   \item the theoretical equilibrium in case of independence \code{"SC"} and competition only \code{"Comp"};
   \item near the theoretical equilibrium (tau=0.95) in case of positive regulation only \code{"RegPos"} (due to infinite possible values for concentrations at this point);
   \item the effective equilibrium in other cases.
} 

Default of \code{E_ini_fun} is \code{NULL} and corresponds to \code{correl_fun} equal to \code{"SC"} or \code{"Comp"},
but in other cases (due to presence of regulation, \code{E_ini_fun} is obligatory and needs to have the same length as \code{A_fun}).
}
\examples{
\donttest{
fsfop <- flux.shape.from.one.point(100,c(1,10,30),"SC")
}

}
\seealso{
To understand differences between discrete and continuous selection coefficients, see function \code{\link{coef_sel.discrete}} and \code{\link{coef_sel.continue}}.
}
