% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_eff_allE0.R
\name{predict_eff_allE0}
\alias{predict_eff_allE0}
\title{Prediction of effective equilibrium for all possible initial relative concentrations}
\usage{
predict_eff_allE0(B_fun,A_fun,correl_fun,Etot_fun=100,X_fun=1, tol=0.00000001)
}
\arguments{
\item{B_fun}{Numeric vector of global co-regulation coefficients. Same length as \code{E_ini_fun}.}

\item{A_fun}{Numeric vector of activities}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{Etot_fun}{Numeric value of total concentration}

\item{X_fun}{Numeric value. Default is \code{1}}

\item{tol}{Tolerance for function \code{\link[stats]{uniroot}}}
}
\value{
Invisible list of 3 elements:
\itemize{
   \item \code{$all_eq_eff}: Dataframe of 4 851 rows and eight columns (named \code{e1,e2,e3,tau,E1,E2,E3,J}) for effective equilibrium from possible initial concentrations.
   Each row corresponds to a set of initial concentrations, and columns are respectively relative concentrations (\code{$e1,$e2,$e3}), driving variable \eqn{\tau} (\code{$tau}), absolute concentrations \code{$E1,$E2,$E3} and flux \code{$J} at effective equilibrium; 
   \item \code{$all_E0}: Dataframe of 4 851 rows and three columns corresponding to initial concentrations. Each row is a triplet of initial concentrations;
   \item \code{$param}: List of input parameters
}
}
\description{
Gives the effective equilibrium for relative concentrations for various initial concentrations
}
\details{
Effective equilibrium is computed with function \code{\link{predict_eff}}.

\emph{\bold{WARNING: Function \code{predict_eff_allE0} is only available for three enzymes!} Length of \code{A_fun} and \code{B_fun} need to be 3.}

Each relative concentration is taken between 0 and 1 by 0.01, then triplet of relative concentrations are sorted to have a sum equal to 1.
Then relative concentrations are multiplied by \code{Etot_fun} to have initial concentrations.

For parameter \code{correl_fun}, authorized input are \code{"RegNeg"}, \code{"CRPos"} and \code{"CRNeg"}.
}
