% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimEUCartelLaw.r
\name{RglPlot}
\alias{RglPlot}
\title{Visualize results of simulation of legal exemption system}
\usage{
RglPlot(res, xvar = "rA", yvar = "rM", zvar = "c", xf = 1, yf = 1,
  zf = 1, userMatrix = rotationMatrix(1.3, -1, 0.28, 0.4), fov = 30,
  zoom = 0.95)
}
\arguments{
\item{res}{dataframe containing results of simulation using \code{LEgame}.}

\item{xvar}{character scalar containing variable for the x-axis.
Defaults to \code{"rA"}, the simulated illegal gain.}

\item{yvar}{character scalar containing variable for the y-axis.
Defaults to \code{"rM"}, the simulated fine.}

\item{zvar}{character scalar containing variable for the z-axis.
Defaults to \code{"c"}, the complicance level.}

\item{xf}{numeric scalar containing scaling constant for the x-axis. Defaults
to \code{1}.}

\item{yf}{numeric scalar containing scaling constant for the y-axis. Defaults
to \code{1}.}

\item{zf}{numeric scalar containing scaling constant for the z-axis. Defaults
to \code{1}.}

\item{userMatrix}{matrix containing information about the initial perspective
used for the plot. Defaults to \code{rotationMatrix(1.3,-1,0.28, 0.4)}.}

\item{fov}{numeric scalar containing the field-of-view angle in degrees.
Defaults to \code{30}.}

\item{zoom}{numeric scalar containing the zoom factor. Defaults to 
\code{0.95}.}
}
\value{
Nothing useful, function called for its side effects.
}
\description{
\code{RglPlot} visualizes the results of the simulation of the legal 
exemption system using 3D-projections and corresponding 3D-plots.
}
\details{
\code{RglPlot} visualizes the results of the simulation of the legal 
exemption system using 3D-projections and corresponding 3D-plots using
\code{rgl}/\code{GL} to produce real 3D plots which can be rotated or
zoomed in/out by the user, even in browser windows via \code{WebGL}.
}
\examples{
\donttest{
Par <- list(Phi=c(0.1,0.5), Rho=c(0.5,0.9), Ksi=c(0.05,0.3), Chi=c(0.1,0.4),
            M=c(0.2,1.2), G=c(0.05,0.2), A=c(0.1,0.3))
RglPlot(LEgame(params=Par, m=10000))
}
}
