% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimFunctions.R
\name{SimFunctions}
\alias{SimFunctions}
\title{Skeleton functions for simulations}
\usage{
SimFunctions(filename = NULL, dir = getwd(), comments = FALSE,
  singlefile = TRUE, summarise = TRUE)
}
\arguments{
\item{filename}{a character vector indicating whether the output should be saved to two respective files
containing the simulation design and the functional components, respectively. Using this option
is generally the recommended approach when beginning to write a Monte Carlo simulation}

\item{dir}{the directory to write the files to. Default is the working directory}

\item{comments}{logical; include helpful comments? Default is \code{FALSE}}

\item{singlefile}{logical; when \code{filename} is included, put output in one files? When \code{FALSE} the
output is saved to two separate files containing the functions and design definitions. The two-file format
often makes organization and debugging slightly easier, especially for larger Monte Carlo simulations.
Default is \code{TRUE}}

\item{summarise}{include \code{summarise} function? Default is \code{TRUE}}
}
\description{
This function prints skeleton versions of the required SimDesign functions
to run simulations, complete with the correct inputs, class of outputs, and optional comments to
help with the initial definitions. Use this at the start of your Monte Carlo simulation study. The
recommended approach is to save the template to the hard-drive by passing a suitable file name.
However, for larger simulations, as well as when using the \code{RStudio}, two
separate files will often be easier for debugging/sourcing the simulation code (achieved by passing
\code{singlefile = FALSE}).
For a didactic presentation of the package refer to Sigal and Chalmers
(2016; \doi{10.1080/10691898.2016.1246953}), and see the associated
wiki on Github (\url{https://github.com/philchalmers/SimDesign/wiki})
for other tutorial material, examples, and applications of \code{SimDesign} to real-world simulations.
}
\examples{

SimFunctions()
SimFunctions(comments = TRUE) #with helpful comments

\dontrun{

# write output to two files (recommended for larger MCSs)
SimFunctions('mysim', singlefile = FALSE)

# write output files to a single file with comments
SimFunctions('mysim', comments = TRUE)
}

}
\references{
Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
