% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimFunctions.R
\name{SimFunctions}
\alias{SimFunctions}
\title{Skeleton functions for simulations}
\usage{
SimFunctions(filename = NULL, comments = FALSE, singlefile = FALSE,
  summarise = TRUE)
}
\arguments{
\item{filename}{a character vector indicating whether the output should be saved to two respective files
containing the simulation design and the functional components, respectively. Using this option
is generally the recommended approach when beginning to write a Monte Carlo simulation}

\item{comments}{logical; include helpful comments? Default is \code{FALSE}}

\item{singlefile}{logical; when \code{filename} is included, put output in one files? When \code{FALSE} the
output is saved to two separate files containing the functions and design definitions. Default is
\code{FALSE}}

\item{summarise}{include \code{summarise} function? Default is \code{TRUE}}
}
\description{
This function prints skeleton versions of the required functions and work-flow required
to run simulations, complete with the correct inputs, class of outputs, and option comments to
help with the initial definitions. Use this at the start when defining your simulation. The
recommended approach when using the \code{RStudio} IDE is to write the simulation template to two
separate files for easier debugging/sourcing.
For a didactic presentation of the package refer to Sigal and Chalmers (in press).
}
\details{
The function \code{SimDesign_functions} is deprecated and will be
removed in a future release.
}
\examples{

SimFunctions()
SimFunctions(comments = TRUE) #with helpful comments

\dontrun{

# write output to two files (recommended)
SimFunctions('mysim')

# write output files to a single file with comments
SimFunctions('mysim', singlefile = TRUE, comments = TRUE)
}

}
\references{
Sigal, M. J., & Chalmers, R. P. (in press). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education}.
}

