% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragments.R
\name{SplitFragments}
\alias{SplitFragments}
\title{Split fragment file by cell identities}
\usage{
SplitFragments(
  object,
  assay = NULL,
  group.by = NULL,
  idents = NULL,
  outdir = getwd(),
  file.suffix = "",
  append = TRUE,
  buffer_length = 256L,
  verbose = TRUE
)
}
\arguments{
\item{object}{A Seurat object}

\item{assay}{Name of assay to use}

\item{group.by}{Name of grouping variable to group cells by}

\item{idents}{List of identities to include}

\item{outdir}{Directory to write output files}

\item{file.suffix}{Suffix to add to all file names (before file extension).
If splitting multiple fragment files without the \code{append} option set to
TRUE, an additional numeric suffix will be added to each file (eg, .1, .2).}

\item{append}{If splitting multiple fragment files, append cells from the
same group (eg cluster) to the same file. Note that this can cause the output
file to be unsorted.}

\item{buffer_length}{Size of buffer to be read from the fragment file. This
must be longer than the longest line in the file.}

\item{verbose}{Display messages}
}
\description{
Splits a fragment file into separate files for each group of cells. If
splitting multiple fragment files containing common cell types, fragments
originating from different files will be appended to the same file for one
group of cell identities.
}
\concept{fragments}
