% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{FoldChange}
\alias{FoldChange}
\title{Compute fold change between two groups of cells}
\usage{
FoldChange(
  object,
  ident.1,
  ident.2 = NULL,
  group.by = NULL,
  cutoff = 0.5,
  assay = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{A Seurat object}

\item{ident.1}{Identities of first group of cells to compare.}

\item{ident.2}{Identities of second group of cells to compare. If NULL,
compare cells in the first group to all other cells.}

\item{group.by}{Grouping variable to use. If NULL, use the current cell
identities.}

\item{cutoff}{Mean count cutoff for classifying as "open". Only used for
ordering results. Results will be ordered first by whether the average counts
in ident.1 is greater than the cutoff value, then by fold change with respect
to ident.2. This prevents very lowly detected peaks from being pushed to the
top of the results due to high fold change values.}

\item{assay}{Name of assay to use. If NULL, use the default assay.}

\item{verbose}{Display messages}
}
\value{
Returns a data.frame
}
\description{
Computes the fold change or log2 fold change (if \code{log=TRUE}) in average
counts between two groups of cells.
}
\examples{
fc <- FoldChange(object = atac_small, ident.1 = 0)
head(fc)
}
\concept{utilities}
