% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{subset.Motif}
\alias{subset.Motif}
\alias{subset}
\alias{[.Motif}
\title{Return a subset of a Motif object}
\usage{
\method{subset}{Motif}(x, features = NULL, motifs = NULL, ...)

\method{[}{Motif}(x, i, j, ...)
}
\arguments{
\item{x}{A Motif object}

\item{features}{Which features to retain}

\item{motifs}{Which motifs to retain}

\item{...}{Arguments passed to other methods}

\item{i}{Which columns to retain}

\item{j}{Which rows to retain}
}
\value{
Returns a subsetted \code{\link{Motif}} object
}
\description{
Return a subset of a Motif object
}
\examples{
motif.obj <- GetMotifObject(object = atac_small)
subset(x = motif.obj, features = head(rownames(motif.obj), 10))
motif.obj <- GetMotifObject(atac_small)
motif.obj[1:10,1:5]
}
\seealso{
\code{\link[base]{subset}}
}
