% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{IntersectMatrix}
\alias{IntersectMatrix}
\title{Intersect genomic coordinates with matrix rows}
\usage{
IntersectMatrix(
  matrix,
  regions,
  invert = FALSE,
  sep = c("-", "-"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{matrix}{A matrix with genomic regions in the rows}

\item{regions}{A set of genomic regions to intersect with regions in the
matrix. Either a vector of strings encoding the genomic coordinates, or a
GRanges object.}

\item{invert}{Discard rows intersecting the genomic regions supplied, rather
than retain.}

\item{sep}{A length-2 character vector containing the separators to be used
for extracting genomic coordinates from a string. The first element will be
used to separate the chromosome name from coordinates, and the second element
used to separate start and end coordinates.}

\item{verbose}{Display messages}

\item{...}{Additional arguments passed to \code{\link[IRanges]{findOverlaps}}}
}
\value{
Returns a sparse matrix
}
\description{
Remove or retain matrix rows that intersect given genomic regions
}
\examples{
counts <- matrix(data = rep(0, 12), ncol = 2)
rownames(counts) <- c("chr1-565107-565550","chr1-569174-569639",
"chr1-713460-714823","chr1-752422-753038",
"chr1-762106-763359","chr1-779589-780271")
IntersectMatrix(matrix = counts, regions = blacklist_hg19)
}
