% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{FeatureMatrix}
\alias{FeatureMatrix}
\title{FeatureMatrix}
\usage{
FeatureMatrix(
  fragments,
  features,
  cells = NULL,
  chunk = 50,
  sep = c("-", "-"),
  verbose = TRUE
)
}
\arguments{
\item{fragments}{Path to tabix-indexed fragments file}

\item{features}{A GRanges object containing a set of genomic intervals.
These will form the rows of the matrix, with each entry recording the number
of unique reads falling in the genomic region for each cell.}

\item{cells}{Vector of cells to include. If NULL, include all cells found
in the fragments file}

\item{chunk}{Number of chunks to use when processing the fragments file.
Fewer chunks may enable faster processing,
 but will use more memory.}

\item{sep}{Vector of separators to use for genomic string. First element is
used to separate chromosome and coordinates, second separator is used to
separate start and end coordinates.}

\item{verbose}{Display messages}
}
\value{
Returns a sparse matrix
}
\description{
Construct a feature x cell matrix from a genomic fragments file
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
FeatureMatrix(
  fragments = fpath,
  features = StringToGRanges(rownames(atac_small), sep = c(":", "-"))
)
}
