% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/preprocessing.R
\name{RunTFIDF}
\alias{RunTFIDF}
\alias{RunTFIDF.default}
\alias{RunTFIDF.Assay}
\alias{RunTFIDF.Seurat}
\title{Compute the term-frequency inverse-document-frequency}
\usage{
RunTFIDF(object, ...)

\method{RunTFIDF}{default}(
  object,
  assay = NULL,
  method = 1,
  scale.factor = 10000,
  verbose = TRUE,
  ...
)

\method{RunTFIDF}{Assay}(
  object,
  assay = NULL,
  method = 1,
  scale.factor = 10000,
  verbose = TRUE,
  ...
)

\method{RunTFIDF}{Seurat}(
  object,
  assay = NULL,
  method = 1,
  scale.factor = 10000,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{...}{Arguments passed to other methods}

\item{assay}{Name of assay to use}

\item{method}{Which TF-IDF implementation to use. Choice of:
\itemize{
 \item{1}: The LSI implementation used by Stuart & Butler et al. 2019 (\url{https://doi.org/10.1101/460147}).
 \item{2}: The standard LSI implementation used by Cusanovich & Hill et al. 2018 (\url{https://doi.org/10.1016/j.cell.2018.06.052}).
 \item{3}: The log-TF method
 \item{4}: The 10x Genomics method (no TF normalization)
}}

\item{scale.factor}{Which scale factor to use. Default is 10000.}

\item{verbose}{Print progress}
}
\value{
Returns a \code{\link[Seurat]{Seurat}} object
}
\description{
Run term frequency inverse document frequency (TF-IDF) normalization
}
\examples{
mat <- matrix(data = rbinom(n = 25, size = 5, prob = 0.2), nrow = 5)
RunTFIDF(object = mat)
RunTFIDF(atac_small[['peaks']])
RunTFIDF(object = atac_small)
}
