% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tabu_shortform.R
\name{tabuShortForm}
\alias{tabuShortForm}
\title{Short Form Tabu Search}
\usage{
tabuShortForm(
  initialModel,
  originalData,
  numItems,
  allItems,
  criterion = function(x) lavaan::fitmeasures(object = x, fit.measures = "rmsea"),
  niter = 30,
  tabu.size = 5,
  lavaan.model.specs = list(int.ov.free = TRUE, int.lv.free = FALSE, std.lv = TRUE,
    auto.fix.first = FALSE, auto.fix.single = TRUE, auto.var = TRUE, auto.cov.lv.x = TRUE,
    auto.th = TRUE, auto.delta = TRUE, auto.cov.y = TRUE, ordered = NULL, model.type =
    "cfa", estimator = "default"),
  bifactor = FALSE
)
}
\arguments{
\item{initialModel}{The initial model (typically the full form) as a character vector with lavaan model.syntax.}

\item{originalData}{The original data frame with variable names.}

\item{numItems}{A numeric vector indicating the number of items to retain for each factor.}

\item{allItems}{For unidimensional models, a character vector of the item names. For multifactor models, a list of the item names, where each element of the list is a factor.}

\item{criterion}{A function calculating the objective criterion to minimize. Default is to use the built-in `rmsea` value from `lavaan::fitmeasures()`.}

\item{niter}{A numeric value indicating the number of iterations (model specification selections)
to perform. Default is 50.}

\item{tabu.size}{A numeric value indicating the size of Tabu list. Default is 5.}

\item{lavaan.model.specs}{A list which contains the specifications for the
lavaan model. The default values are the defaults for lavaan to perform a
CFA. See \link[lavaan]{lavaan} for more details.}

\item{bifactor}{Logical. Indicates if the latent model is a bifactor model. If `TRUE`, assumes that the last latent variable in the provided model syntax is the bifactor (i.e., all of the retained items will be set to load on the last latent variable).}
}
\value{
A named list with the best value of the objective function (`best.obj`) and the best lavaan model object (`best.mod`).
}
\description{
Given an initial (full) lavaan model string, the original data, a criterion
function to minimize, and some additional specifications,
performs a Tabu model specification search. Currently only supports
neighbors that are 1 move away from the current model.
}
\examples{
shortAntModel = '
Ability =~ Item1 + Item2 + Item3 + Item4 + Item5 + Item6 + Item7 + Item8
Ability ~ Outcome
'
data(simulated_test_data)
tabuResult <- tabuShortForm(initialModel = shortAntModel,
                             originalData = simulated_test_data, numItems = 7,
                             allItems = colnames(simulated_test_data)[3:11],
                             niter = 1, tabu.size = 3)
lavaan::summary(tabuResult$best.mod) # shows the resulting model

}
