% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_AttitudesExpulsion.R
\docType{data}
\encoding{utf-8}
\name{AttitudesExpulsion}
\alias{AttitudesExpulsion}
\title{Attitudes towards the Expulsion of the Sudeten Germans (dataset)}
\format{
A \emph{data.frame} with 145 rows and
239 variables:
\describe{
\item{ID}{anonymous identifier}
\item{Group}{C = control or E = experimental group}
\item{Gender}{\emph{factor}, \code{male} or \code{female}}
\item{GenderF}{\emph{integer}, 1 = female}
\item{Merkel}{effect of Merkel speech between the posttest and the delayed
posttest, range 0--5, where 0 stands for no effect, 5 for very significant
effect}
\item{Sudety}{\emph{factor}, N = not originally from Czech Borderlands; Y =
originally from Czech Borderlands}
\item{Education}{\emph{factor}, V = university; S = high school; Z = elementary
school}
\item{Education123}{\emph{integer}, same as above, but coded as 3= university;
2= high school; 1= elementary school, meaning higher the number, higher the
education}
\item{*PANASpn}{total PANAS score of positive and negative affect scales}
\item{*PANASp}{total PANAS score of positive affect scale}
\item{*PANASn}{total PANAS score of negative affect scale}
\item{*Macro}{Macro attitude measurement}
\item{*Micro}{Micro attitude measurement}
\item{*IATeffect}{Single-Category Implicit association test score}
}

Items beginning with an asterisk have following prefixes in the actual
dataset:
\describe{
\item{pre}{pretest}
\item{post}{immediate posttest}
\item{del}{one month delayed posttest}
\item{Post_Pre}{difference between posttest_pretest}
\item{Del_Post}{difference between delayed posttest and posttest}
}
}
\source{
{ Kolek, L., Šisler, V., Martinková, P., & Brom, C. (2021). Can video
games change attitudes towards history? Results from a laboratory experiment
measuring short- and long-term effects. \emph{Journal of Computer Assisted
Learning}, \emph{1--22}. \doi{10.1111/jcal.12575}}
}
\usage{
AttitudesExpulsion
}
\description{
Dataset from Kolek et al. (2021) study investigating a video game's effects
on implicit and explicit attitudes towards depicted historical events in the
short- and long-term. As an intervention tool, a serious game
\emph{Czechoslovakia 38–89: Borderlands} was utilized that deals with the
expulsion of the Sudeten Germans from the former Czechoslovakia after the
WWII. Data consists responses from 145 adults from two groups (experimental
and control group) on number of multi-item measurements.
}
\keyword{datasets}
