% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDIFLogistic.R
\name{plotDIFLogistic}
\alias{plotDIFLogistic}
\title{Function for characteristic curve of 2PL logistic DIF model}
\usage{
plotDIFLogistic(x, item = 1, item.name, group.names = c("Reference", "Focal"),
Data, group, match, draw.empirical = TRUE)
}
\arguments{
\item{x}{an object of \code{"Logistic"} class. See \strong{Details}.}

\item{item}{numeric: number of item to be plotted}

\item{item.name}{character: the name of item to be used as title of plot.}

\item{group.names}{character: names of reference and focal group.}

\item{Data}{numeric: the data matrix. See \strong{Details}.}

\item{group}{numeric: the vector of group membership. See \strong{Details}.}

\item{match}{character or numeric: specifies observed score used for matching. Can be either \code{"score"},
or numeric vector of the same length as number of observations in \code{Data}. See \strong{Details}.}

\item{draw.empirical}{logical: whether empirical probabilities should be calculated and plotted.
Default value is \code{TRUE}.}
}
\description{
Plots characteristic curve of 2PL logistic DIF model
}
\details{
This function plots characteristic curves of 2PL logistic DIF model fitted
by \code{difLogistic()} function from difR package using ggplot2.

\code{Data} and \code{group} are used to calculate empirical probabilities for reference
and focal group. \code{match} should be the same as in \code{x$match}. In case that an
observed score is used as a matching variable instead of the total score or the standardized score,
\code{match} needs to be a numeric vector of the same the same length as the number of observations
in \code{Data}.
}
\examples{
# loading libraries
library(difR)

# loading data based on GMAT
data(GMAT, package = "difNLR")
Data <- GMAT[, 1:20]
group <- GMAT[, 21]

# DIF detection using difLogistic() function
x <- difLogistic(Data, group, focal.name = 1)
# Characteristic curve by logistic regression model
plotDIFLogistic(x, item = 1, Data = Data, group = group)

# Using name of column as item identifier
plotDIFLogistic(x, item = "Item1", Data = Data, group = group)

# Renaming reference and focal group
plotDIFLogistic(x, item = 1, group.names = c("Group 1", "Group 2"), Data = Data, group = group)

# Not plotting empirical probabilities
plotDIFLogistic(x, item = 1, draw.empirical = FALSE)
}
\seealso{
\code{\link[difR]{difLogistic}}, \code{\link[ggplot2]{ggplot}}
}
\author{
Adela Hladka \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
