% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DDplot.R
\name{DDplot}
\alias{DDplot}
\title{Graphical representation of difficulty and (generalized) discrimination in item analysis}
\usage{
DDplot(data, item.names, k = 3, l = 1, u = 3,
discrim = "ULI", maxscore, minscore, bin = FALSE, cutscore)
}
\arguments{
\item{data}{numeric: binary or ordinal data matrix or data frame. See \strong{Details}.}

\item{item.names}{character: the names of items.}

\item{k}{numeric: number of groups to which may be data.frame x divided by the total score.
Default value is 3.  See \strong{Details}.}

\item{l}{numeric: lower group. Default value is 1. See \strong{Details}.}

\item{u}{numeric: upper group. Default value is 3. See \strong{Details}.}

\item{discrim}{character: type of discrimination index to be calculated. Deafult value is "ULI". See \strong{Details}.}

\item{maxscore}{vector or numeric: maximal scores of items. If numeric, the same maximal score is used for all items. If missing, vector of achieved maximal scores is calculated and used in calculations.}

\item{minscore}{vector or numeric: minimal scores of items. If numeric, the same minimal score is used for all items. If missing, vector of achieved minimal scores is calculated and used in calculations.}

\item{bin}{logical: should the ordinal data be binarized. Deafult value is FALSE. See \strong{Details}.}

\item{cutscore}{vector or numeric: cutscore used to binarize the data.set. If numeric, the same cutscore is used for all items. If missing, vector of maximal scores is used in calculations.}
}
\description{
Plots difficulty and (generalized) discrimination for items ordered by difficulty.
}
\details{
The \code{data} is a matrix or data frame whose rows represents examinee answers
(\code{1} correct, \code{0} incorrect, or ordinal item scores) and columns correspond to the items.

The \code{item.names} argument stands for names of items. If not specified, the names of dataset columns are used.
Difficulty and discrimination indices are plotted for each item, items are ordered by their difficulty.

Discrimination is calculated using method specified in \code{discrim}. Default option "ULI"
calculates difference in ratio of correct answers in upper and lower third of students.
"RIT" index caluclates correlation between item score and test total score.
"RIR" index caclulates correlation between item score and total score for the rest of the items.
With option "none", only difficulty is displayed.

"ULI" index can be generalized using arguments \code{k}, \code{l} and \code{u}. Generalized ULI
discrimination is then computed as follows: The function takes data on individuals,
computes their total test score and then divides individuals into \code{k} groups. The lower and
upper group are determined by \code{l} and \code{u} parameters, i.e.  l-th and u-th group where
the ordering is defined by increasing total score.

For ordinal data, difficulty is defined as relative score (achieved - minimal)/(maximal - minimal).
Minimal score can be specified by \code{minscore}, maximal score can be specified by \code{maxscore}.

Binarization of data is allowed in \code{bin}, for this purpose \code{cutscore} is used.
}
\note{
Generalized discrimination is calculated by \code{\link{gDiscrim}} function.
}
\examples{
\dontrun{
# loading 100-item medical admission test data sets
data(dataMedical, dataMedicalgraded)
# binary data set
dataBin <- dataMedical[, 1:100]
# ordinal data set
dataOrd <- dataMedicalgraded[, 1:100]

# DDplot of binary data set
DDplot(dataBin)
# compared to DDplot using ordinal data set and 'bin = TRUE'
DDplot(dataOrd, bin = TRUE)
# compared to binarized data set using bin = TRUE and cutscore equal to 3
DDplot(dataOrd, bin = TRUE, cutscore = 3)

# DDplot of binary data using generalized ULI
# discrimination based on 5 groups, comparing 4th and 5th
DDplot(dataBin, k = 5, l = 4, u = 5)

# DDplot of ordinal data set using ULI
DDplot(dataOrd)
# DDplot of ordinal data set using generalized ULI
# discrimination based on 5 groups, comparing 4th and 5th
DDplot(dataOrd, k = 5, l = 4, u = 5)
# DDplot of ordinal data set using RIT
DDplot(dataOrd, discrim = "RIT")
# DDplot of ordinal data set using RIR
DDplot(dataOrd, discrim = "RIR")
# DDplot of ordinal data set disaplaying only difficulty
DDplot(dataBin, discrim = "none")
}
}
\references{
Martinkova, P., Stepanek, L., Drabinova, A., Houdek, J., Vejrazka, M., & Stuka, C. (2017).
Semi-real-time analyses of item characteristics for medical school admission tests.
In: Proceedings of the 2017 Federated Conference on Computer Science and Information Systems.
}
\seealso{
\code{\link{gDiscrim}}, \code{\link{discrim}}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
drabinova@cs.cas.cz \cr

Lubos Stepanek \cr
First Faculty of Medicine, Charles University \cr
lubomir.stepanek@lf1.cuni.cz \cr

Jana Vorlickova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}
