% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_wt.r
\name{sd_wt}
\alias{sd_wt}
\title{Function to calculate weighted standard deviation}
\usage{
sd_wt(x, w, na.rm = FALSE)
}
\arguments{
\item{x}{Vector containing the values in the set}

\item{w}{Vector containing the weights to each value (in
the same order as \code{x}
the optimized growth model}

\item{na.rm}{Should NA values be removed from the set prior
to calculation? \code{TRUE/FALSE}}
}
\value{
The standard deviation of the weighted set of \code{x} values
}
\description{
Calculates the standard deviation of a weighted sample set
while propagating sample weights through the calculation.
}
\examples{
# Create dummy data
x <- seq(1, 10, 0.5)
w <- c(seq(0.1, 1, 0.1), seq(0.9, 0.1, -0.1))
SDw <- sd_wt(x, w, na.rm = TRUE) # Run the function
}
