% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tests.r
\name{sr_unpaired_test}
\alias{sr_unpaired_test}
\title{test for equation on unpaired Sharpe ratios}
\usage{
sr_unpaired_test(srs,contrasts=NULL,null.value=0,
  alternative=c("two.sided","less","greater"),
  ope=NULL,conf.level=0.95)
}
\arguments{
\item{srs}{a (non-empty) list of objects of class \code{sr}, each containing
a scalar sample Sharpe estimate. Or a single object of class \code{sr} with
multiple Sharpe estimates.}

\item{contrasts}{an array of the constrasts, the \eqn{a_j}{a_j} values.
Defaults to \code{c(1,-1,1,...)}.}

\item{null.value}{the constant null value, the \eqn{b}{b}.
Defaults to 0.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or
\code{"less"}.  You can specify just the initial letter.}

\item{ope}{the number of observations per 'epoch'. For convenience of
interpretation, The Sharpe ratio is typically quoted in 'annualized'
units for some epoch, that is, 'per square root epoch', though returns
are observed at a frequency of \code{ope} per epoch.
The default value is to take the same \code{ope} from the input \code{srs}
object, if it is unambiguous. Otherwise, it defaults to 1, with a warning
thrown.}

\item{conf.level}{confidence level of the interval.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"htest"} containing the following components:
\item{statistic}{\code{NULL} here.}
\item{parameter}{a list of upsilon parameters.}
\item{p.value}{the p-value for the test.}
\item{conf.int}{a confidence interval appropriate to the specified alternative hypothesis.}
\item{estimate}{the estimated equation value, just the weighted sum of the sample Sharpe ratios. Annualized}
\item{null.value}{the specified hypothesized value of the sum of Sharpes.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
Performs hypothesis tests on a single equation on k independent samples of Sharpe ratio.
}
\details{
For \eqn{1 \le j \le k}{1 <= j <= k}, suppose you have \eqn{n_j}{n_j}
observations of a normal random variable with mean \eqn{\mu_j}{mu_j} and
standard deviation \eqn{\sigma_j}{sigma_j}, with all observations
independent. Given constants \eqn{a_j}{a_j} and value \eqn{b}{b}, this
code tests the null hypothesis
\deqn{H_0: \sum_j a_j \frac{\mu_j}{\sigma_j} = b}{H0: sum_j a_j mu_j/sigma_j = b}
against two or one sided alternatives.
}
\examples{
# basic usage
set.seed(as.integer(charToRaw("set the seed")))
# default contrast is 1,-1,1,-1,1,-1
etc <- sr_unpaired_test(as.sr(matrix(rnorm(1000*6,mean=0.02,sd=0.1),ncol=6)))
print(etc)

etc <- sr_unpaired_test(as.sr(matrix(rnorm(1000*4,mean=0.0005,sd=0.01),ncol=4)),
  alternative='greater')
print(etc)

etc <- sr_unpaired_test(as.sr(matrix(rnorm(1000*4,mean=0.0005,sd=0.01),ncol=4)),
  contrasts=c(1,1,1,1),null.value=-0.1,alternative='greater')
print(etc)

inp <- list(as.sr(rnorm(500)),as.sr(runif(200)-0.5),
            as.sr(rnorm(30)),as.sr(rnorm(100)))
etc <- sr_unpaired_test(inp)

inp <- list(as.sr(rnorm(500)),as.sr(rnorm(100,mean=0.2,sd=1)))
etc <- sr_unpaired_test(inp,contrasts=c(1,1),null.value=0.2)
etc$conf.int
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
Sharpe, William F. "Mutual fund performance." Journal of business (1966): 119-138.
\url{http://ideas.repec.org/a/ucp/jnlbus/v39y1965p119.html}

Pav, Steven. "Inference on the Sharpe ratio via the upsilon distribution.'
Arxiv (2015).
\url{http://arxiv.org/abs/1505.00829}
}
\seealso{
\code{\link{sr_equality_test}}, \code{\link{sr_test}}, \code{\link{t.test}}.

Other sr: \code{\link{as.sr}},
  \code{\link{as.sr.data.frame}},
  \code{\link{as.sr.default}}, \code{\link{as.sr.lm}},
  \code{\link{as.sr.matrix}},
  \code{\link{as.sr.timeSeries}}, \code{\link{as.sr.xts}};
  \code{\link{confint.del_sropt}},
  \code{\link{confint.sr}}, \code{\link{confint.sropt}};
  \code{\link{dsr}}, \code{\link{psr}}, \code{\link{qsr}},
  \code{\link{rsr}}; \code{\link{is.sr}};
  \code{\link{plambdap}}, \code{\link{qlambdap}},
  \code{\link{rlambdap}}; \code{\link{power.sr_test}};
  \code{\link{predint}}; \code{\link{print.del_sropt}},
  \code{\link{print.sr}}, \code{\link{print.sropt}};
  \code{\link{reannualize}}, \code{\link{reannualize.sr}},
  \code{\link{reannualize.sropt}}; \code{\link{se}},
  \code{\link{se.sr}}; \code{\link{sr_equality_test}};
  \code{\link{sr_test}}; \code{\link{sr_vcov}};
  \code{\link{sr}}
}
\keyword{htest}

