% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.shapley_interaction}
\alias{plot.shapley_interaction}
\title{Plot of Shapley interaction indices}
\usage{
\method{plot}{shapley_interaction}(
  x,
  abbrev = 4,
  title = "Shapley Interaction",
  legend = TRUE,
  text_size = 22,
  ...
)
}
\arguments{
\item{x}{A \eqn{p \times p} matrix containing the Shapley interaction indices (\code{\link{shapley_interaction}}) of a single observation.}

\item{abbrev}{Integer. If \code{abbrev.var} \eqn{> 0}, variable names are abbreviated using abbreviate with \code{minlenght = abrev}.}

\item{title}{Character. Title of the plot.}

\item{legend}{Logical. If TRUE (default), a legend is plotted.}

\item{text_size}{Integer. Size of the text in the plot}

\item{...}{Optional arguments passed to methods.}
}
\value{
Returns a figure consisting of two panels. The upper panel shows the Shapley values, and the lower panel the Shapley interaction indices.
}
\description{
Plot of Shapley interaction indices
}
\examples{
p <- 5
mu <- rep(0,p)
Sigma <- matrix(0.9, p, p); diag(Sigma) = 1
Sigma_inv <- solve(Sigma)
x <- c(0,1,2,2.3,2.5)
PHI <- shapley_interaction(x, mu, Sigma)
plot(PHI)
}
