% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{new_shapley_algorithm}
\alias{new_shapley_algorithm}
\title{Class constructor for class \code{shapley_algorithm}.}
\usage{
new_shapley_algorithm(
  x = numeric(),
  phi = numeric(),
  x_original = numeric(),
  mu_tilde = NULL,
  non_centrality = NULL,
  x_history = NULL,
  phi_history = NULL,
  mu_tilde_history = NULL,
  S_history = NULL
)
}
\arguments{
\item{x}{A \eqn{p}-dimensional vector (or a \eqn{n \times p} matrix) containing the imputed data.}

\item{phi}{A \eqn{p}-dimensional vector (or a \eqn{n \times p} matrix) containing the
Shapley values (outlyingness-scores) of a \eqn{p}-dimensional data vector (or a \eqn{n \times p} data matrix).}

\item{x_original}{A \eqn{p}-dimensional vector (or a \eqn{n \times p} matrix) containing the original data.}

\item{mu_tilde}{Optional. A \eqn{p}-dimensional vector (or a \eqn{n \times p} matrix) containing the
alternative reference points based on the regular cells of the original observations.}

\item{non_centrality}{Optional. The non-centrality parameters for the Chi-Squared distribution,
which are given by \code{mahlanobis(mu_tilde, mu, Sigma)}.}

\item{x_history}{Optional. A list with \eqn{n} elements, each containing the path of how the original data vector was modified.}

\item{phi_history}{Optional. A list with \eqn{n} elements, each containing the Shapley values corresponding to \code{x_history}.}

\item{mu_tilde_history}{Optional. A list with \eqn{n} elements, each containing the alternative reference points corresponding to \code{x_history}.}

\item{S_history}{Optional. A list with \eqn{n} elements, each containing the indices of the outlying cells in each iteration.}
}
\value{
Named list of class \code{shapley_algorithm}, containing the input parameters.
}
\description{
This function creates an object of class \code{shapley_algorithm} that is returned
by the \code{\link{SCD}} and \code{\link{MOE}} functions.
}
