\name{batchssr}
\alias{batchssr}

\title{
Calls ShrinkShape (ssr) in batch mode
}

\description{
When multiple shapes need to be processed with ShrinkShape, then having this batch utility process all files in a folder can be useful (e.g., if a shapefile with multiple unique polygons was initially split with shpsplitter). Processes all .shp files in the working directory.
}

\usage{
batchssr(outfile = "out.csv", START = 1)
}

\arguments{
  \item{outfile}{
This is the name of a .csv text file to which the output results are written (it is a continually added to as the batch processing continues). The path and filename can be specified here and later be used external to the R environment if necessary.
}

  \item{START}{
At times it is necessary to begin processing a batch of files from a specific point (not necessarily the beginning); specifying this parameter as an integer will start processing a list of files from this specific point. The default is 1, the first file. This option is included in case of a crash (which initially happened due to a power failure) and then the processing could be restarted easily from where it was terminated.
}
}

\value{
The output is simply a sequential .csv text file that contains the area, perimeter, and number of parts decomposition information for each iteration and each shape processed by the batch function. The columns in the output file also identify the unique shape id, the iteration number on each row, and the cumulative shrinking distance associated with each iteration.
}

\references{
Remmel, T.K. 2016. Classifying boreal wildfires by clustering ShrinkShape spectra of internal unburned vegetation patches. US-IALE 2016 Annual Meeting: Landscape Change, 3-7 April, Asheville, North Carolina, USA. 
}

\author{
Tarmo K. Remmel
}

\note{
This function works nicely on the output generated by the function shpsplitter, such that each shapefile to be processed will contain exactly one unique shape (as identified by the attribute GRIDCODE). Projection units must be meters and not an angular unit (e.g., decimal degrees).
}

\seealso{
See Also \code{\link{shpsplitter}}, \code{\link{ssr}} 
}

\examples{
# Simply calls ssr for each instance of a .shp file in the working directory. 
# Functionality is the same as for ssr, this is just a wrapper funciton.
}

\keyword{ manip }
