% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seurat.R
\name{Seurat-methods}
\alias{Seurat-methods}
\alias{.DollarNames.Seurat}
\alias{$.Seurat}
\alias{$<-.Seurat}
\alias{[.Seurat}
\alias{[[.Seurat}
\alias{dim.Seurat}
\alias{dimnames.Seurat}
\alias{head.Seurat}
\alias{merge.Seurat}
\alias{merge}
\alias{MergeSeurat}
\alias{AddSamples}
\alias{names.Seurat}
\alias{subset.Seurat}
\alias{subset}
\alias{tail.Seurat}
\alias{[[<-,Seurat,ANY,ANY,ANY-method}
\alias{colMeans,Seurat-method}
\alias{colSums,Seurat-method}
\alias{rowMeans,Seurat-method}
\alias{rowSums,Seurat-method}
\alias{show,Seurat-method}
\title{Seurat Methods}
\usage{
\method{.DollarNames}{Seurat}(x, pattern = "")

\method{$}{Seurat}(x, i, ...)

\method{$}{Seurat}(x, i, ...) <- value

\method{[}{Seurat}(x, i, j, ...)

\method{[[}{Seurat}(x, i, ..., drop = FALSE)

\method{dim}{Seurat}(x)

\method{dimnames}{Seurat}(x)

\method{head}{Seurat}(x, n = 10L, ...)

\method{merge}{Seurat}(
  x = NULL,
  y = NULL,
  add.cell.ids = NULL,
  merge.data = TRUE,
  merge.dr = NULL,
  project = "SeuratProject",
  ...
)

\method{names}{Seurat}(x)

\method{subset}{Seurat}(
  x,
  subset,
  cells = NULL,
  features = NULL,
  idents = NULL,
  return.null = FALSE,
  ...
)

\method{tail}{Seurat}(x, n = 10L, ...)

\S4method{[[}{Seurat,ANY,ANY,ANY}(x, i, j, ...) <- value

\S4method{colMeans}{Seurat}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{colSums}{Seurat}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{rowMeans}{Seurat}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{rowSums}{Seurat}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{show}{Seurat}(object)
}
\arguments{
\item{x, object}{A \code{\link{Seurat}} object}

\item{pattern}{ A regular expression.  Only matching names are
    returned.
  }

\item{i, features}{Depends on the method
\describe{
 \item{\code{[}, \code{subset}}{Feature names or indices}
 \item{\code{$}, \code{$<-}}{Name of a single metadata column}
 \item{\code{[[}, \code{[[<-}}{
  Name of one or more metadata columns or an associated object; associated
  objects include \code{\link{Assay}}, \code{\link{DimReduc}},
  \code{\link{Graph}}, \code{\link{SeuratCommand}}, or
  \code{\link{SpatialImage}} objects
 }
}}

\item{...}{Arguments passed to other methods}

\item{value}{Additional metadata or associated objects to add; \strong{note}:
can pass \code{NULL} to remove metadata or an associated object}

\item{j, cells}{Cell names or indices}

\item{drop}{See \code{\link[base]{drop}}}

\item{n}{The number of rows of metadata to return}

\item{y}{A single \code{Seurat} object or a list of \code{Seurat} objects}

\item{add.cell.ids}{A character vector of \code{length(x = c(x, y))};
appends the corresponding values to the start of each objects' cell names}

\item{merge.data}{Merge the data slots instead of just merging the counts
(which requires renormalization); this is recommended if the same
normalization approach was applied to all objects}

\item{merge.dr}{Merge specified DimReducs that are present in all objects;
will only merge the embeddings slots for the first \code{N} dimensions that
are shared across all objects.}

\item{project}{\link{Project} name for the \code{Seurat} object}

\item{subset}{Logical expression indicating features/variables to keep}

\item{idents}{A vector of identity classes to keep}

\item{return.null}{If no cells are request, return a \code{NULL};
by default, throws an error}

\item{na.rm}{logical.  Should missing values (including \code{NaN})
    be omitted from the calculations?}

\item{dims}{completely ignored by the \code{Matrix} methods.}

\item{slot}{Name of assay expression matrix to calculate column/row
means/sums on}
}
\value{
\code{$}: metadata column \code{i} for object \code{x};
\strong{note}: unlike \code{[[}, \code{$} drops the shape of the metadata
to return a vector instead of a data frame

\code{$<-}: object \code{x} with metadata \code{value} saved as
\code{i}

\code{[}: object \code{x} with features \code{i} and cells \code{j}

\code{[[}: If \code{i} is missing, the metadata data frame; if
\code{i} is a vector of metadata names, a data frame with the requested
metadata, otherwise, the requested associated object

\code{dim}: The number of features (\code{nrow}) and cells
(\code{ncol}) for the default assay; \strong{note}: while the number of
features changes depending on the active assay, the number of cells remains
the same across all assays

\code{dimnames}: The feature (row) and cell (column) names;
\strong{note}: while the features change depending on the active assay, the
cell names remain the same across all assays

\code{head}: The first \code{n} rows of cell-level metadata

\code{merge}: Merged object

\code{names}: The names of all \code{\link{Assay}},
\code{\link{DimReduc}}, \code{\link{Graph}}, and \code{\link{SpatialImage}}
objects in the \code{Seurat} object

\code{subset}: A subsetted \code{Seurat} object

\code{tail}: The last \code{n} rows of cell-level metadata

\code{[[<-}: \code{x} with the metadata or associated objects added
as \code{i}; if \code{value} is \code{NULL}, removes metadata or associated
object \code{i} from object \code{x}

\code{show}: Prints summary to \code{\link[base]{stdout}} and
invisibly returns \code{NULL}
}
\description{
Methods for \code{\link{Seurat}} objects for generics defined in other
packages
}
\section{Functions}{
\itemize{
\item \code{.DollarNames.Seurat}: Autocompletion for \code{$} access on a
\code{Seurat} object

\item \code{$.Seurat}: Metadata access for \code{Seurat} objects

\item \code{$<-.Seurat}: Metadata setter for \code{Seurat} objects

\item \code{[.Seurat}: Simple subsetter for \code{Seurat} objects

\item \code{[[.Seurat}: Metadata and associated object accessor

\item \code{dim.Seurat}: Number of cells and features for the active assay

\item \code{dimnames.Seurat}: The cell and feature names for the active assay

\item \code{head.Seurat}: Get the first rows of cell-level metadata

\item \code{merge.Seurat}: Merge two or more \code{Seurat} objects together

\item \code{names.Seurat}: Common associated objects

\item \code{subset.Seurat}: Subset a \code{\link{Seurat}} object

\item \code{tail.Seurat}: Get the last rows of cell-level metadata

\item \code{[[<-,Seurat,ANY,ANY,ANY-method}: Add cell-level metadata or associated objects

\item \code{colMeans,Seurat-method}: Calculate \code{\link[base]{colMeans}} on a
\code{Seurat} object

\item \code{colSums,Seurat-method}: Calculate \code{\link[base]{colSums}} on a
\code{Seurat} object

\item \code{rowMeans,Seurat-method}: Calculate \code{\link[base]{rowMeans}} on a
\code{rowMeans} object

\item \code{rowSums,Seurat-method}: Calculate \code{\link[base]{rowSums}} on a
\code{Seurat} object

\item \code{show,Seurat-method}: Overview of a \code{Seurat} object
}}

\section{Merge Details}{

When merging Seurat objects, the merge procedure will merge the Assay level
counts and potentially the data slots (depending on the merge.data parameter).
It will also merge the cell-level meta data that was stored with each object
and preserve the cell identities that were active in the objects pre-merge.
The merge will optionally merge reductions depending on the values passed to
\code{merge.dr} if they have the same name across objects. Here the
embeddings slots will be merged and if there are differing numbers of
dimensions across objects, only the first N shared dimensions will be merged.
The feature loadings slots will be filled by the values present in the first
object.The merge will not preserve graphs, logged commands, or feature-level
metadata that were present in the original objects. If add.cell.ids isn't
specified and any cell names are duplicated, cell names will be appended
with _X, where X is the numeric index of the object in c(x, y).
}

\examples{
# Get metadata using `$'
head(pbmc_small$groups)

# Add metadata using the `$' operator
set.seed(42)
pbmc_small$value <- sample(1:3, size = ncol(pbmc_small), replace = TRUE)
head(pbmc_small[["value"]])

# `[' examples
pbmc_small[VariableFeatures(object = pbmc_small), ]
pbmc_small[, 1:10]

# Get the cell-level metadata data frame
head(pbmc_small[[]])

# Pull specific metadata information
head(pbmc_small[[c("letter.idents", "groups")]])
head(pbmc_small[["groups", drop = TRUE]])

# Get a sub-object (eg. an `Assay' or `DimReduc')
pbmc_small[["RNA"]]
pbmc_small[["pca"]]

# Get the number of features in an object
nrow(pbmc_small)

# Get the number of cells in an object
ncol(pbmc_small)

# Get the feature names of an object
rownames(pbmc_small)

# Get the cell names of an object
colnames(pbmc_small)

# Get the first 10 rows of cell-level metadata
head(pbmc_small)

# `merge' examples
# merge two objects
merge(pbmc_small, y = pbmc_small)
# to merge more than two objects, pass one to x and a list of objects to y
merge(pbmc_small, y = c(pbmc_small, pbmc_small))

names(pbmc_small)

# `subset' examples
subset(pbmc_small, subset = MS4A1 > 4)
subset(pbmc_small, subset = `DLGAP1-AS1` > 2)
subset(pbmc_small, idents = '0', invert = TRUE)
subset(pbmc_small, subset = MS4A1 > 3, slot = 'counts')
subset(pbmc_small, features = VariableFeatures(object = pbmc_small))

# Get the last 10 rows of cell-level metadata
tail(pbmc_small)

head(colMeans(pbmc_small))

head(colSums(pbmc_small))

head(rowMeans(pbmc_small))

head(rowSums(pbmc_small))

}
\seealso{
\code{\link[base]{subset}} \code{\link{WhichCells}}
}
\concept{seurat}
