% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{SpatiallyVariableFeatures}
\alias{SpatiallyVariableFeatures}
\alias{SpatiallyVariableFeatures.Assay}
\alias{SpatiallyVariableFeatures.Seurat}
\title{Get spatially variable feature information}
\usage{
SpatiallyVariableFeatures(object, ...)

\method{SpatiallyVariableFeatures}{Assay}(
  object,
  selection.method = "markvariogram",
  decreasing = TRUE,
  ...
)

\method{SpatiallyVariableFeatures}{Seurat}(
  object,
  assay = NULL,
  selection.method = "markvariogram",
  decreasing = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object, assay, or expression matrix}

\item{...}{Arguments passed to other methods}

\item{selection.method}{Method for selecting spatially variable features.
 \itemize{
  \item \code{markvariogram}: See \code{\link{RunMarkVario}} for details
  \item \code{moransi}: See \code{\link{RunMoransI}} for details.
}}

\item{decreasing}{Return features in decreasing order (most spatially
variable first).}

\item{assay}{Name of assay to pull spatially variable features for}

\item{Seurat}{object}
}
\description{
Get spatially variable feature information
}
