% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{AverageExpression}
\alias{AverageExpression}
\title{Averaged feature expression by identity class}
\usage{
AverageExpression(object, assays = NULL, features = NULL,
  return.seurat = FALSE, add.ident = NULL, slot = "data",
  use.scale = FALSE, use.counts = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{object}{Seurat object}

\item{assays}{Which assays to use. Default is all assays}

\item{features}{Features to analyze. Default is all features in the assay}

\item{return.seurat}{Whether to return the data as a Seurat object. Default is FALSE}

\item{add.ident}{Place an additional label on each cell prior to averaging (very useful if you want to observe cluster averages, separated by replicate, for example)}

\item{slot}{Slot to use; will be overriden by \code{use.scale} and \code{use.counts}}

\item{use.scale}{Use scaled values for feature expression}

\item{use.counts}{Use count values for feature expression}

\item{verbose}{Print messages and show progress bar}

\item{...}{Arguments to be passed to methods such as \code{\link{CreateSeuratObject}}}
}
\value{
Returns a matrix with genes as rows, identity classes as columns.
If return.seurat is TRUE, returns an object of class \code{\link{Seurat}}.
}
\description{
Returns expression for an 'average' single cell in each identity class
}
\details{
Output is in log-space when \code{return.seurat = TRUE}, otherwise it's in non-log space.
Averaging is done in non-log space.
}
\examples{
head(AverageExpression(object = pbmc_small))

}
