% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{RefinedMapping}
\alias{RefinedMapping}
\title{Quantitative refinement of spatial inferences}
\usage{
RefinedMapping(object, genes.use)
}
\arguments{
\item{object}{Seurat object}

\item{genes.use}{Genes to use to drive the refinement procedure.}
}
\value{
Seurat object, where mapping probabilities for each bin are stored
in object@final.prob
}
\description{
Refines the initial mapping with more complex models that allow gene
expression to vary quantitatively across bins (instead of 'on' or 'off'),
and that also considers the covariance structure between genes.
}
\details{
Full details given in spatial mapping manuscript.
}
\examples{
\dontrun{
# Note that the PBMC test example object does not contain spatially restricted
# examples below are only demonstrate code
pmbc_small <- RefinedMapping(pbmc_small, genes.use=pbmc_small@var.genes)
}

}
