% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differential_expression.R
\name{TobitTest}
\alias{TobitTest}
\title{Differential expression testing using Tobit models}
\usage{
TobitTest(object, cells.1, cells.2, genes.use = NULL, print.bar = TRUE)
}
\arguments{
\item{object}{Seurat object}

\item{cells.1}{Group 1 cells}

\item{cells.2}{Group 2 cells}

\item{genes.use}{Genes to test. Default is to use all genes}

\item{print.bar}{Print a progress bar once expression testing begins (uses pbapply to do this)}
}
\value{
Returns a p-value ranked matrix of putative differentially expressed
genes.
}
\description{
Identifies differentially expressed genes between two groups of cells using
Tobit models, as proposed in Trapnell et al., Nature Biotechnology, 2014
}
\examples{
pbmc_small
\dontrun{
TobitTest(pbmc_small, cells.1 = WhichCells(object = pbmc_small, ident = 1),
            cells.2 = WhichCells(object = pbmc_small, ident = 2))
}

}
