% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{set_node_names}
\alias{set_node_names}
\title{Set the node names in a network}
\usage{
set_node_names(network, node_names)
}
\arguments{
\item{network}{The network to modify.}

\item{node_names}{A vector of strings containing the names for each node
in the network. If a numeric vector is provided, the values will be coerced
into strings. If 'node_names' is \code{NULL}, then the names will default to
"1", "2", ..., "p".}
}
\value{
The modified network.
}
\description{
Set the node names in a network
}
\examples{
# Create a random network with 10 nodes. 
nw <- random_network(10)
get_node_names(nw) # Default names are 1, 2, ..., 10.
nw <- set_node_names(nw, paste("node", 1:10, sep = "_"))
get_node_names(nw) # Print out updated node names.
# Modules only contain the indicies to nodes, not the node names
module <- nw$modules[[1]]
get_node_names(module)
# When converting the network to a matrix, node names appear as column names.
adj_matrix <- get_adjacency_matrix(nw)
colnames(adj_matrix) 
}
