% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyzeSentiment.R
\name{analyzeSentiment}
\alias{analyzeSentiment}
\alias{analyzeSentiment.Corpus}
\alias{analyzeSentiment.character}
\alias{analyzeSentiment.data.frame}
\alias{analyzeSentiment.TermDocumentMatrix}
\alias{analyzeSentiment.DocumentTermMatrix}
\title{Sentiment analysis}
\usage{
analyzeSentiment(
  x,
  language = "english",
  aggregate = NULL,
  rules = defaultSentimentRules(),
  removeStopwords = TRUE,
  stemming = TRUE,
  ...
)

\method{analyzeSentiment}{Corpus}(
  x,
  language = "english",
  aggregate = NULL,
  rules = defaultSentimentRules(),
  removeStopwords = TRUE,
  stemming = TRUE,
  ...
)

\method{analyzeSentiment}{character}(
  x,
  language = "english",
  aggregate = NULL,
  rules = defaultSentimentRules(),
  removeStopwords = TRUE,
  stemming = TRUE,
  ...
)

\method{analyzeSentiment}{data.frame}(
  x,
  language = "english",
  aggregate = NULL,
  rules = defaultSentimentRules(),
  removeStopwords = TRUE,
  stemming = TRUE,
  ...
)

\method{analyzeSentiment}{TermDocumentMatrix}(
  x,
  language = "english",
  aggregate = NULL,
  rules = defaultSentimentRules(),
  removeStopwords = TRUE,
  stemming = TRUE,
  ...
)

\method{analyzeSentiment}{DocumentTermMatrix}(
  x,
  language = "english",
  aggregate = NULL,
  rules = defaultSentimentRules(),
  removeStopwords = TRUE,
  stemming = TRUE,
  ...
)
}
\arguments{
\item{x}{A vector of characters, a \code{data.frame}, an object of type 
\code{\link[tm]{Corpus}}, \code{\link[tm]{TermDocumentMatrix}} or
\code{\link[tm]{DocumentTermMatrix}}}

\item{language}{Language used for preprocessing operations (default: 
English)}

\item{aggregate}{A factor variable by which documents can be grouped. 
This helpful when joining e.g. news from the same day or move reviews
by the same author}

\item{rules}{A named list containing individual sentiment metrics. 
Therefore, each entry consists itself of a list with first a method,
followed by an optional dictionary.}

\item{removeStopwords}{Flag indicating whether to remove stopwords or not (default: yes)}

\item{stemming}{Perform stemming (default: TRUE)}

\item{...}{Additional parameters passed to function for e.g. 
preprocessing}
}
\value{
Result is a matrix with sentiment values for each document across
all defined rules
}
\description{
Performs sentiment analysis  of given object (vector of strings, document-term 
matrix, corpus).
}
\details{
This function returns a data.frame with continuous values. If one desires 
other formats, one needs to convert these. Common examples of such formats are
binary response values (positive / negative) or tertiary (positive, neutral, 
negative). Hence, consider using the functions \code{\link{convertToBinaryResponse}} and
\code{\link{convertToDirection}}, which can convert a vector of continuous sentiment
scores into a factor object.
}
\examples{
\dontrun{
library(tm)

# via vector of strings
corpus <- c("Positive text", "Neutral but uncertain text", "Negative text")
sentiment <- analyzeSentiment(corpus)
compareToResponse(sentiment, c(+1, 0, -2))

# via Corpus from tm package
data("crude")
sentiment <- analyzeSentiment(crude)
    
# via DocumentTermMatrix (with stemmed entries)
dtm <- DocumentTermMatrix(VCorpus(VectorSource(c("posit posit", "negat neutral")))) 
sentiment <- analyzeSentiment(dtm)
compareToResponse(sentiment, convertToBinaryResponse(c(+1, -1)))

# By adapting the parameter rules, one can incorporate customized dictionaries
# e.g. in order to adapt to arbitrary languages
dictionaryAmplifiers <- SentimentDictionary(c("more", "much"))
sentiment <- analyzeSentiment(corpus,
                              rules=list("Amplifiers"=list(ruleRatio,
                                                           dictionaryAmplifiers)))
                                                           
# On can also restrict the number of computed methods to the ones of interest
# in order to achieve performance optimizations
sentiment <- analyzeSentiment(corpus,
                              rules=list("SentimentLM"=list(ruleSentiment, 
                                                            loadDictionaryLM())))
sentiment
}

}
\seealso{
\code{\link{compareToResponse}} for evaluating the results, 
\code{\link{convertToBinaryResponse}} and \code{\link{convertToDirection}} for
for getting binary results, \code{\link{generateDictionary}} for dictionary generation, 
\code{\link{plotSentiment}} and \code{\link{plotSentimentResponse}} for visualization
}
\keyword{sentiment}
