\name{pmfa}

\alias{pmfa}

\title{Procrustean Multiple Factor Analysis (PMFA)}

\description{
Performs Multiple Factor Analysis combined with Procrustean Analysis.
}

\usage{
pmfa(matrice, matrice.illu = NULL, mean.conf = NULL, dilat = TRUE,
      graph.ind = TRUE, lim = c(60,40), coord = c(1,2), cex = 0.8)
}

\arguments{
  \item{matrice}{a data frame of dimension (\emph{p,2j}), where \emph{p} represents the number 
  of products and \emph{j} the number of panelists}
  \item{matrice.illu}{a data frame with illustrative variables (with the same row.names in common as in \code{matrice})}  
  \item{mean.conf}{coordinates of the average configuration (by default NULL, the average configuration is generated by MFA)}  
  \item{dilat}{boolean, if TRUE (which is the default value) the Morand's dilatation is used}  
  \item{graph.ind}{boolean, if TRUE (which is the default value) superimposes each panelist's configuration on the average configuration}  
  \item{lim}{size of the tablecothe}  
  \item{coord}{a length 2 vector specifying the components to plot}
  \item{cex}{cf. function \code{\link{par}} in the \pkg{graphics} package}
}

\details{
Performs first Multiple Factor Analysis on the tableclothes, then GPA in order to superimpose as well
as possible panelist's configuration on the average configuration obtained by MFA (in the case where \code{mean.conf} is NULL).
If \code{mean.conf} is not NULL the configuration used is the one input by the user.
}

\value{
Returns the RV coefficient between each individual configuration and the consensus. \cr
If \code{mean.conf} is NULL, returns the usual graphs resulting from the afmult function: the graph of the individuals and their partial representations,
the graph of the variables (i.e. the coordinates of the products given by each panelist). \cr
If \code{mean.conf} is not NULL returns the configuration input by the user. \cr
When \code{matrice.illu} is not NULL, returns a graph of illustrative variables. \cr
Returns as many superimposed representations of individual configurations as there are panelists.
}

\references{
Morand, E., Pags, J. (accepted) Procrustes multiple factor analysis to analyze the overall perception of food products.
\emph{Food Quality and Preference}
}

\author{Franois Husson, Sbastien L}

\seealso{\code{\link{afmult}}, \code{\link{nappeplot}}, \code{\link{indscal}}}

\examples{
\dontrun{
data(napping.don)
data(napping.words)
nappeplot(napping.don)
get(getOption("device"))()
pmfa(napping.don, napping.words)
}
}
\keyword{multivariate}
