% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SensIAT_sim_outcome_modeler_mave.R
\name{SensIAT_sim_outcome_modeler_mave}
\alias{SensIAT_sim_outcome_modeler_mave}
\title{Single Index Model using MAVE and Optimizing Bandwidth.}
\usage{
SensIAT_sim_outcome_modeler_mave(
  formula,
  data,
  kernel = "K2_Biweight",
  mave.method = "meanMAVE",
  id = ..id..,
  bw.selection = c("ise", "mse"),
  bw.method = c("optim", "grid", "optimize"),
  bw.range = c(0.01, 1.5),
  reestimate.coef = FALSE,
  ...
)
}
\arguments{
\item{formula}{The outcome model formula}

\item{data}{The data to fit the outcome model to.
Should only include follow-up data, i.e. time > 0.}

\item{kernel}{The kernel to use for the outcome model.}

\item{mave.method}{The method to use for the MAVE estimation.}

\item{id}{The patient identifier variable for the data.}

\item{bw.selection}{The criteria for bandwidth selection, either \code{'ise'} for Integrated Squared Error or \code{'mse'} for Mean Squared Error.}

\item{bw.method}{The method for bandwidth selection, either \code{'optim'} for using optimization or \code{'grid'} for grid search.}

\item{bw.range}{A numeric vector of length 2 indicating the range of bandwidths to consider for selection as a multiple of the standard deviation of the single index predictor.}

\item{reestimate.coef}{Logical indicating whether to re-estimate the coefficients of the outcome model after bandwidth selection.}

\item{...}{Additional arguments to be passed to \link{optim}.}
}
\value{
Object of class \code{SensIAT::Single-index-outcome-model} which contains the outcome model portion.
}
\description{
Single index model estimation using minimum average variance estimation (MAVE).
A direction is estimated using MAVE, and then the bandwidth is selected by
minimization of the cross-validated pseudo-integrated squared error.
Optionally, the initial coefficients of the outcome model can be re-estimated
by optimization on a spherical manifold.  This option requires the
\link[ManifoldOptim:manifold.optim]{ManifoldOptim} package.
}
