% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partboot.one.test.R
\name{partboot.one.test}
\alias{partboot.one.test}
\title{Wrapper function for \code{\link[SemNeT]{partboot.test}}}
\usage{
partboot.one.test(partboot.obj)
}
\arguments{
\item{partboot.obj}{Object from \code{\link[SemNeT]{partboot}}}
}
\value{
Returns a list containing the objects:

\item{ASPL}{Test statistics for each percentage of nodes remaining for ASPL}

\item{CC}{Test statistics for each percentage of nodes remaining for CC}

\item{Q}{Test statistics for each percentage of nodes remaining for Q}

If two groups:

A matrix in each object has the following columns:

\item{t-statistic}{Statistic from the \code{\link{t.test}}}

\item{df}{Degrees of freedom}

\item{p-value}{\emph{p}-value with values equal to \code{0} being \emph{p} < .001}

\item{d}{Cohen's \emph{d}}

\item{CI95.lower}{Lower bound of the 95 percent confidence interval}

\item{CI95.upper}{Upper bound of the 95 percent confidence interval}

\item{Direction}{Direction of the effect. The argument \code{groups} will
specify specifically which group is higher or lower on the measure. If no
groups are input, then \code{"d"} and \code{"p"} are used to represent
\code{data} and \code{paired} samples from \code{\link[SemNeT]{partboot}}, respectively}

Row names refer to the percentage of nodes remaining in bootstrapped networks

If three or more groups:

A list containing two objects:

\item{ANOVA}{A matrix containing the \emph{F}-statistic, group degrees of freedom,
residual degrees of freedom, \emph{p}-value, and partial eta squared {\code{p.eta.sq}}}

\item{HSD}{A matrix containing the differences between each group (\code{diff}),
lower (\code{lwr}) and upper (\code{upr}) bounds of the 95% confidence interval,
and the adjusted \emph{p}-value (\code{p adj})}
}
\description{
Computes statistical tests for partial bootstrapped
networks from \code{\link[SemNeT]{partboot}}. Automatically
computes \emph{t}-tests (\code{\link{t.test}}) or ANOVA
(\code{\link{aov}}) including Tukey's HSD for pairwise comparisons
(\code{\link{TukeyHSD}})
}
\examples{
# Simulate Dataset
one <- sim.fluency(20)
two <- sim.fluency(20)
\donttest{
# Run partial bootstrap networks
two.result <- partboot(one, two, percent = .50, iter = 1000,
sim = "cosine", cores = 2)
}
# Compute tests
partboot.one.test(two.result)

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
