% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoboost.R
\name{plot.selectboost}
\alias{plot.selectboost}
\title{Plot selectboost object}
\usage{
\method{plot}{selectboost}(
  x,
  verbose = FALSE,
  prop.level = 0.95,
  conf.int.level = 0.95,
  conf.threshold = 0.95,
  ...
)
}
\arguments{
\item{x}{Numerical matrix. Result of selectboost (autoboost, fastboost, ...).}

\item{verbose}{Boolean.
Defaults to \code{FALSE}.}

\item{prop.level}{Numeric value. Used to compute the proportion of selection is
greater than prop.level. Defaults to \code{.95}.}

\item{conf.int.level}{Numeric value. Confidence level for confidence intervals on estimated
proportions of selection. Defaults to \code{.95}.}

\item{conf.threshold}{Numeric value. Used to compute the number of steps (c0) for which
the proportion of selection remains greater than conf.threshold. Defaults to \code{.95}.}

\item{...}{. Passed to the plotting functions.}
}
\value{
An invisible list.
}
\description{
Plot a selectboostboost object.
}
\details{
\code{plot.selectboost} returns an invisible list and creates four graphics.
Two plots the proportion of selection with respect to c0 (by step or according to real scale).
On the third graph, no bar means a proportion of selection less than prop.level.
Confidence intervals are computed at the conf.int.level level.
Barplot of the confidence index (1-min(c0, such that proportion|c0>conf.threshold)).
}
\examples{
set.seed(314)
xran=matrix(rnorm(75),15,5)
ybin=sample(0:1,15,replace=TRUE)
yran=rnorm(15)
layout(matrix(1:4,2,2))

data(autoboost.res.x)
plot(autoboost.res.x)

data(autoboost.res.x2)
plot(autoboost.res.x2)

}
\references{
\emph{selectBoost: a general algorithm to enhance the performance of variable selection methods in correlated datasets}, Frédéric Bertrand, Ismaïl Aouadi, Nicolas Jung, Raphael Carapito, Laurent Vallat, Seiamak Bahram, Myriam Maumy-Bertrand, \url{https://arxiv.org/abs/1810.01670}
}
\seealso{
\code{\link{fastboost}}, \code{\link{autoboost}}

Other Selectboost analyse functions: 
\code{\link{force.non.inc}()},
\code{\link{summary.selectboost}()}
}
\author{
Frederic Bertrand, \email{frederic.bertrand@math.unistra.fr}
}
\concept{Selectboost analyse functions}
