\name{Segmentor-package}
\alias{Segmentor-package}
\docType{package}
\title{
Implementation of the Pruned Dynamic Programming Algorithm for the exact optimal segmentation of profiles
}
\description{
Exact change-point algorithm for the segmentation of profiles according
}
\details{
\tabular{ll}{
Package: \tab Segmentor3IsBack\cr
Type: \tab Package\cr
Version: \tab 1.4 \cr
Date: \tab 2013-03-25\cr
License: \tab GPL\cr
LazyLoad: \tab yes\cr
}

}
\author{
Alice Cleynen

Maintainer: Alice Cleynen <alice.cleynen@agroparistech.fr>
}

\references{
  PDPA: Rigaill, G. Pruned dynamic programming for optimal multiple change-point detection: \emph{Submitted} \url{http://arxiv.org/abs/1004.0887}

  PDPA: Cleynen, A. and Koskas, M. and Rigaill, G. A Generic Implementation of the Pruned Dynamic Programing Algorithm: \emph{Submitted} \url{http://arxiv.org/abs/1204.5564}

  overdispersion parameter: Johnson, N. and Kemps, A. and Kotz, S. (2005) Univariate Discrete Distributions: \emph{John Wiley & Sons} 
  
  variance parameter: Hall, P. and Kay, J. and Titterington, D. (1990): Asymptotically optimal difference-based estimation of variance in non-parametric regression \emph{Biometrika}
  
  Selection criterion for counts: Cleynen, A. and Lebarbier, E. Segmentation of the Poisson and negative binomial rate models: a penalized estimator: \emph{Submitted} \url{http://arxiv.org/abs/1301.2534}
  
  Selection criterion for Gaussian distribution: Lebarbier, E. (2005) Detecting multiple change-points in the mean of Gaussian process by model selection: \emph{Signal Processing}
  
  Slope heuristic: Arlot, S. and Bach, F. (2009) Data-driven calibration of penalties for least-squares regression: \emph{Journal of Machine Learning Research}
  
  modified BIC: Zhang, N. and Siegmund, D. (2007) A modified Bayes information criterion with applications to the analysis of comparative genomic hybridization data: \emph{Biometrics}
}

\keyword{changepoint}
\keyword{segmentation}
\keyword{exact}
\keyword{counts}
\keyword{sselection}
\examples{
N=2000 
x=c(rnbinom(N,size=1.3,prob=0.7),rnbinom(N,size=1.3,prob=0.2),
rnbinom(N,size=1.3,prob=0.01), rnbinom(N,size=1.3,prob=0.2),rnbinom(N,size=1.3,prob=0.8));
res=Segmentor(data=x,model=3,Kmax=20);  
# Finds the optimal segmentation in up to 20 segments with respect to 
#the negative binomial model.
Cr<-SelectModel(res,penalty='oracle',keep=FALSE)
Cr
#chooses the number of segments in the segmentation of x
}
