% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{MSES}
\alias{MSES}
\title{Mean Square Error Skill score}
\usage{
MSES(dt, f, o = "obs", by = by_cols_ens_fc_score(), pool = c("year"), ...)
}
\arguments{
\item{dt}{Data table containing the predictions.}

\item{f}{column name of the prediction.}

\item{o}{column name of the observations.}

\item{by}{column names of grouping variables, all of which need to be columns in dt. A separate MSE is computed for each value of the grouping variables.
Default is to group by all instances of month, season, lon, lat, system and lead_time that are columns in dt.}

\item{pool}{column name(s) for the variable(s) along which is averaged. Needs to contain 'year' since the reference climatology forecast is leave-one-year-out.}

\item{...}{passed on to MSE}
}
\value{
A data table with the scores
}
\description{
Function for taking MSE skill scores of ensemble forecasts stored in long data tables.
Can also handle point forecasts.
The skill score needs a climatological forecast as reference. This is so far always based on the leave-one-year-out climatology.
}
\examples{
dt = data.table(fc = 1:4,obs = c(4,4,7,7),member = c(1,2,1,2),year = c(1999,1999,2000,2000))
MSES(dt,f = 'fc')

}
