% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Voronoi.R
\name{Voronoi}
\alias{Voronoi}
\title{Voronoi tessellation diagram}
\usage{
Voronoi(n = 100, d, dim = 1000, method = NULL, seed = 51, plot = TRUE)
}
\arguments{
\item{n}{an integer for a finite set of points.}

\item{d}{an integer for a finite set of dimensions.}

\item{dim}{the image dimension.}

\item{method}{the distance computation method. One of \code{euclidean, manhattan, maximum, canberra} (currently not implemented).}

\item{seed}{an integer for random seed.}

\item{plot}{logical. If \code{TRUE}, a plot is returned, else, a \code{data.frame} is returned.}
}
\description{
Computes voronoi tessellation diagrams, and Dirichlet tessellation (after Peter Gustav Lejeune Dirichlet).
}
\details{
\url{https://en.wikipedia.org/wiki/Voronoi_diagram}
}
\examples{
\dontrun{ Voronoi(n=20, d=5, dim=1000) }

}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}

