% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stratify.R
\encoding{UTF-8}
\name{Stratify}
\alias{Stratify}
\title{Stratified Sampling}
\usage{
Stratify(.data, group, size, select = NULL, replace = FALSE,
  both.sets = FALSE)
}
\arguments{
\item{.data}{the data frame.}

\item{group}{the grouping factor, may be a list.}

\item{size}{the sample size.}

\item{select}{if sampling from a specific group or list of groups.}

\item{replace}{should sampling be with replacement?}

\item{both.sets}{if \code{TRUE}, both `sample` and `.data` are returned.}
}
\description{
Sample row values of a data frame conditional to some strata attributes.
}
\examples{

data(pollster2008)

# Let's take a 10\% sample from all -PollTaker- groups in pollster2008
 Stratify(pollster2008, "PollTaker", 0.1)

 # Let's take a 10\% sample from only 'LV' and 'RV' groups from -Pop- in pollster2008
 Stratify(pollster2008, "Pop", 0.1, select = list(Pop = c("LV", "RV")))

 # Let's take 3 samples from all -PollTaker- groups in pollster2008,
 # specified by column 1
Stratify(pollster2008, group = 1, size = 3)

# Let's take a sample from all -Pop- groups in pollster2008, where we
# specify the number wanted from each group
Stratify(pollster2008, "Pop", size = c(3, 5, 4))

# Use a two-column strata (-Pop- and -PollTaker-) but only interested in
# cases where -Pop- == 'LV'
Stratify(pollster2008, c("Pop", "PollTaker"), 0.15, select = list(Pop = "LV"))

}
\keyword{Manipulation}

