% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/electoralTool.R
\name{rosenbluth}
\alias{rosenbluth}
\title{Rosenbluth Index of Concentration}
\usage{
rosenbluth(x, n = rep(1, length(x)), na.rm = FALSE, ...)

rosenbluth(x, n = rep(1, length(x)), na.rm = FALSE, ...)
}
\arguments{
\item{x}{A vector of data values of non-negative elements.}

\item{n}{A vector of frequencies of the same length as \code{x}.}

\item{na.rm}{A logical. Should missing values be removed? The Default is set to \code{na.rm=FALSE}.}

\item{\dots}{Additional arguements (currently ignored)}
}
\description{
Calculates the Rosenbluth Index of concentration, also known as Hall or Tiedemann Indices.
}
\examples{
# generate a vector (of incomes)
x <- c(778, 815, 857, 888, 925, 930, 965, 990, 1012)

# compute Rosenbluth coefficient
rosenbluth(x)
}
\references{
Cowell, F. A. (2000) Measurement of Inequality in Atkinson, A. B. / Bourguignon, F. (Eds): \emph{Handbook of Income Distribution}. Amsterdam.

Cowell, F. A. (1995) \emph{Measuring Inequality} Harvester Wheatshef: Prentice Hall.
}
\seealso{
\code{\link{atkinson}}, \code{\link{herfindahl}},  \code{\link{gini}}. For more details see the Indices vignette: \code{vignette("Indices", package = "SciencesPo")}.
}

